/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.parlor.game.client;

import com.threerings.parlor.Log;
import com.threerings.parlor.game.data.GameConfig;
import com.threerings.parlor.util.ParlorContext;

public abstract class GameConfigurator {
    protected ParlorContext _ctx;
    protected GameConfig _config;

    public void init(ParlorContext ctx) {
        this._ctx = ctx;
        this.createConfigInterface();
    }

    protected void createConfigInterface() {
    }

    public void setGameConfig(GameConfig config) {
        this._config = config;
        try {
            this.gotGameConfig();
        }
        catch (RuntimeException re) {
            Log.log.warning((Object)"Unable to fill in interface from config, trying to use a default config", new Object[]{re});
            try {
                this._config = (GameConfig)config.getClass().newInstance();
            }
            catch (Exception e) {
                Log.log.warning((Object)"Unable to create replacement game config", new Object[]{"class", e.getClass(), e});
                throw re;
            }
            this.gotGameConfig();
        }
    }

    protected void gotGameConfig() {
    }

    public GameConfig getGameConfig() {
        this.flushGameConfig();
        return this._config;
    }

    protected void flushGameConfig() {
    }
}

