/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.stage.tools.editor.util;

import com.threerings.util.DirectionUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;

public class EditorDialogUtil {
    public static void addButton(ActionListener l, Container container, String name, String cmd) {
        JButton button = new JButton(name);
        button.addActionListener(l);
        button.setActionCommand(cmd);
        container.add(button);
    }

    public static JComboBox getOrientationComboBox(ActionListener l) {
        JComboBox<String> box = new JComboBox<String>(DirectionUtil.getDirectionNames());
        box.addActionListener(l);
        box.setActionCommand("orient");
        return box;
    }

    public static void center(JFrame parent, JInternalFrame dialog) {
        Dimension psize = parent.getSize();
        Dimension dsize = dialog.getSize();
        dialog.setLocation((psize.width - dsize.width) / 2, (psize.height - dsize.height) / 2);
    }

    public static void display(JFrame parent, JInternalFrame dialog) {
        EditorDialogUtil.center(parent, dialog);
        parent.getLayeredPane().add((Component)dialog, JLayeredPane.POPUP_LAYER);
        dialog.setVisible(true);
    }

    public static void dismiss(JInternalFrame dialog) {
        Container parent = dialog.getParent();
        if (parent != null) {
            parent.remove(dialog);
            parent.repaint();
        }
        dialog.setVisible(false);
    }

    public static void dispose(JInternalFrame dialog) {
        EditorDialogUtil.dismiss(dialog);
        dialog.dispose();
    }
}

