/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.stage.tools.editor;

import com.google.common.collect.Sets;
import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.HGroupLayout;
import com.samskivert.util.ComparableArrayList;
import com.threerings.media.image.ColorPository;
import com.threerings.media.tile.NoSuchTileSetException;
import com.threerings.media.tile.RecolorableTileSet;
import com.threerings.media.tile.TileManager;
import com.threerings.media.tile.TileSet;
import com.threerings.media.tile.TileUtil;
import com.threerings.miso.data.ObjectInfo;
import com.threerings.miso.data.SparseMisoSceneModel;
import com.threerings.miso.tile.MisoTileManager;
import com.threerings.stage.data.StageMisoSceneModel;
import com.threerings.stage.data.StageScene;
import com.threerings.stage.tools.editor.DirectionButton;
import com.threerings.stage.tools.editor.EditorModel;
import com.threerings.stage.tools.editor.EditorScenePanel;
import com.threerings.stage.tools.editor.util.EditorContext;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.List;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class SceneInfoPanel
extends JPanel
implements ActionListener {
    protected EditorContext _ctx;
    protected StageScene _scene;
    protected JTextField _scenename;
    protected JComboBox _scenetype;
    protected JComboBox _colorClasses;
    protected JComboBox _colorIds;
    protected EditorScenePanel _svpanel;
    protected DirectionButton _dirbutton;

    public SceneInfoPanel(EditorContext ctx, EditorModel model, EditorScenePanel svpanel) {
        this._ctx = ctx;
        this._svpanel = svpanel;
        HGroupLayout gl = new HGroupLayout();
        gl.setGap(12);
        this.setLayout((LayoutManager)gl);
        JPanel vert = GroupLayout.makeVStretchBox((int)5);
        JPanel hbox = GroupLayout.makeHBox();
        this._scenename = new JTextField(10);
        hbox.add(this.createLabel("Scene name:", this._scenename));
        this._scenename.addActionListener(this);
        this._scenename.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                SceneInfoPanel.this._scenename.postActionEvent();
            }
        });
        ComparableArrayList types = new ComparableArrayList();
        ctx.enumerateSceneTypes((List<String>)types);
        types.sort();
        types.add(0, (Object)"");
        this._scenetype = new JComboBox<Object>(types.toArray());
        hbox.add(this.createLabel("Scene type:", this._scenetype));
        this._scenetype.addActionListener(this);
        vert.add(hbox);
        hbox = GroupLayout.makeButtonBox((GroupLayout.Justification)GroupLayout.LEFT, (Component[])new Component[0]);
        this._colorClasses = new JComboBox();
        hbox.add(this._colorClasses);
        this._colorIds = new JComboBox();
        hbox.add(this._colorIds);
        vert.add((Component)this.createLabel("Colorizations:", hbox), GroupLayout.FIXED);
        this._colorClasses.addActionListener(this);
        this._colorIds.addActionListener(this);
        this._colorClasses.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                SceneInfoPanel.this.recomputeColorClasses();
            }
        });
        this.add((Component)vert, GroupLayout.FIXED);
    }

    protected JPanel createLabel(String label, JComponent comp) {
        JPanel panel = GroupLayout.makeButtonBox((GroupLayout.Justification)GroupLayout.CENTER, (Component[])new Component[0]);
        panel.add((Component)new JLabel(label), GroupLayout.FIXED);
        panel.add(comp);
        return panel;
    }

    public void setScene(StageScene scene) {
        this._scene = scene;
        this._scenename.setText(scene.getName());
        this._scenetype.setSelectedItem(scene.getType());
        this.recomputeColorClasses();
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this._scenename) {
            this._scene.setName(this._scenename.getText().trim());
        } else if (src == this._scenetype) {
            this._scene.setType((String)this._scenetype.getSelectedItem());
        } else if (src == this._colorClasses) {
            String cclass = (String)this._colorClasses.getSelectedItem();
            this.configureColorIds(cclass);
        } else if (src == this._colorIds) {
            this.setNewDefaultColor();
        }
    }

    protected void recomputeColorClasses() {
        MisoTileManager tilemgr = this._ctx.getTileManager();
        TreeSet set = Sets.newTreeSet();
        StageMisoSceneModel msmodel = StageMisoSceneModel.getSceneModel(this._scene.getSceneModel());
        msmodel.visitObjects(new SparseMisoSceneModel.ObjectVisitor((TileManager)tilemgr, set){
            private final /* synthetic */ TileManager val$tilemgr;
            private final /* synthetic */ TreeSet val$set;
            {
                this.val$tilemgr = tileManager;
                this.val$set = treeSet;
            }

            public void visit(ObjectInfo info) {
                TileSet tset;
                int tsid = TileUtil.getTileSetId((int)info.tileId);
                try {
                    tset = this.val$tilemgr.getTileSet(tsid);
                }
                catch (NoSuchTileSetException nstse) {
                    return;
                }
                if (!(tset instanceof RecolorableTileSet)) {
                    return;
                }
                String[] zations = ((RecolorableTileSet)tset).getColorizations();
                if (zations != null) {
                    String[] stringArray = zations;
                    int n = zations.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String zation = stringArray[n2];
                        this.val$set.add(zation);
                        ++n2;
                    }
                }
            }
        });
        Object selected = this._colorClasses.getSelectedItem();
        DefaultComboBoxModel model = (DefaultComboBoxModel)this._colorClasses.getModel();
        model.removeAllElements();
        for (String zation : set) {
            model.addElement(zation);
        }
        if (selected != null) {
            this._colorClasses.setSelectedItem(selected);
        }
    }

    protected void configureColorIds(String cclass) {
        this._colorIds.removeActionListener(this);
        try {
            String noChoice;
            DefaultComboBoxModel model = (DefaultComboBoxModel)this._colorIds.getModel();
            model.removeAllElements();
            if (cclass == null) {
                return;
            }
            ColorPository cpos = this._ctx.getColorPository();
            String choice = noChoice = "<none>";
            ColorPository.ClassRecord classRec = cpos.getClassRecord(cclass);
            int pick = this._scene.getDefaultColor(classRec.classId);
            ColorPository.ColorRecord[] colors = cpos.enumerateColors(cclass);
            ComparableArrayList list = new ComparableArrayList();
            ColorPository.ColorRecord[] colorRecordArray = colors;
            int n = colors.length;
            int n2 = 0;
            while (n2 < n) {
                ColorPository.ColorRecord color = colorRecordArray[n2];
                list.insertSorted((Comparable)((Object)color.name));
                if (color.colorId == pick) {
                    choice = color.name;
                }
                ++n2;
            }
            model.addElement(noChoice);
            int ii = 0;
            while (ii < list.size()) {
                model.addElement(list.get(ii));
                ++ii;
            }
            this._colorIds.setSelectedItem(choice);
        }
        finally {
            this._colorIds.addActionListener(this);
        }
    }

    protected void setNewDefaultColor() {
        String cclass = (String)this._colorClasses.getSelectedItem();
        if (cclass == null) {
            return;
        }
        ColorPository cpos = this._ctx.getColorPository();
        ColorPository.ClassRecord classRec = cpos.getClassRecord(cclass);
        ColorPository.ColorRecord[] colors = cpos.enumerateColors(cclass);
        Object selected = this._colorIds.getSelectedItem();
        int pick = -1;
        ColorPository.ColorRecord[] colorRecordArray = colors;
        int n = colors.length;
        int n2 = 0;
        while (n2 < n) {
            ColorPository.ColorRecord color = colorRecordArray[n2];
            if (color.name.equals(selected)) {
                pick = color.colorId;
                break;
            }
            ++n2;
        }
        if (this._scene.getDefaultColor(classRec.classId) != pick) {
            this._scene.setDefaultColor(classRec.classId, pick);
            this._svpanel.setScene(this._scene);
            this._svpanel.repaint();
        }
    }
}

