/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.puzzle.server;

import com.samskivert.util.IntListUtil;
import com.samskivert.util.Interval;
import com.samskivert.util.RandomUtil;
import com.samskivert.util.RunQueue;
import com.threerings.parlor.game.server.GameManager;
import com.threerings.presents.data.ClientObject;
import com.threerings.puzzle.Log;
import com.threerings.puzzle.data.Board;
import com.threerings.puzzle.data.BoardSummary;
import com.threerings.puzzle.data.PuzzleCodes;
import com.threerings.puzzle.data.PuzzleGameMarshaller;
import com.threerings.puzzle.data.PuzzleObject;
import com.threerings.puzzle.server.PuzzleGameProvider;
import java.util.Arrays;

public abstract class PuzzleManager
extends GameManager
implements PuzzleCodes,
PuzzleGameProvider {
    protected PuzzleObject _puzobj;
    protected Board[] _boards;
    protected Interval _statusInterval;
    protected long[] _lastProgress;

    public Board[] getBoards() {
        return this._boards;
    }

    public BoardSummary getBoardSummary(int pidx) {
        return this._puzobj == null || this._puzobj.summaries == null ? null : this._puzobj.summaries[pidx];
    }

    public boolean needsBoardSummaries() {
        return false;
    }

    protected boolean compareBeforeApply() {
        return true;
    }

    protected void handleBoardNotEqual() {
        System.exit(0);
    }

    public void updateBoardSummary(int pidx) {
        if (this._puzobj.summaries != null && this._puzobj.summaries[pidx] != null) {
            this._puzobj.summaries[pidx].summarize();
        }
    }

    public void updateBoardSummaries() {
        if (this._puzobj.summaries != null) {
            int ii = 0;
            while (ii < this._puzobj.summaries.length) {
                if (!this.isAI(ii) || this.summarizeAIBoard()) {
                    this.updateBoardSummary(ii);
                }
                ++ii;
            }
        }
    }

    protected void playerGameDidEnd(int pidx) {
        super.playerGameDidEnd(pidx);
        this.updateSummaryOnDeath(pidx);
    }

    protected void updateSummaryOnDeath(int pidx) {
        if (!this.isAI(pidx)) {
            this.updateBoardSummary(pidx);
        }
        this.updateStatus();
    }

    protected boolean summarizeAIBoard() {
        return false;
    }

    protected void didStartup() {
        super.didStartup();
        this._puzobj = (PuzzleObject)this._gameobj;
        this._puzobj.setPuzzleGameService((PuzzleGameMarshaller)this.addProvider(this, PuzzleGameMarshaller.class));
    }

    protected void gameWillStart() {
        int size = this.getPlayerSlots();
        if (this._boards == null) {
            this._boards = new Board[size];
            this._lastProgress = new long[size];
        } else {
            Arrays.fill(this._boards, null);
        }
        Arrays.fill(this._lastProgress, System.currentTimeMillis());
        this._puzobj.setDifficulty(this.computeDifficulty());
        this._puzobj.setSeed(RandomUtil.rand.nextLong());
        this.initBoards();
        super.gameWillStart();
        this.sendStatusUpdate();
        long statusInterval = this.getStatusInterval();
        if (this._statusInterval == null && statusInterval > 0L) {
            this._statusInterval = new Interval((RunQueue)this._omgr){

                public void expired() {
                    PuzzleManager.this.sendStatusUpdate();
                }
            };
            this._statusInterval.schedule(statusInterval, true);
        }
    }

    protected long getStatusInterval() {
        return 0L;
    }

    protected int computeDifficulty() {
        return 2;
    }

    protected void gameDidStart() {
        super.gameDidStart();
        if (this._AIs != null) {
            Log.log.info((Object)"AIs on the job", new Object[]{"game", this._puzobj.which(), "skillz", this._AIs});
        }
    }

    protected void sendStatusUpdate() {
        this._puzobj.startTransaction();
        try {
            this.updateStatus();
        }
        finally {
            this._puzobj.commitTransaction();
        }
    }

    protected void updateStatus() {
        if (this.needsBoardSummaries()) {
            this.updateBoardSummaries();
            this._puzobj.setSummaries(this._puzobj.summaries);
        }
    }

    protected void systemMessage(String msg) {
        this.systemMessage(msg, false);
    }

    protected void systemMessage(String msg, boolean waitForStart) {
        this.systemMessage("puzzle.general", msg, waitForStart);
    }

    protected void initBoards() {
        long seed = this._puzobj.seed;
        BoardSummary[] summaries = this.needsBoardSummaries() ? new BoardSummary[this.getPlayerSlots()] : null;
        int ii = 0;
        int nn = this.getPlayerSlots();
        while (ii < nn) {
            boolean needsPlayerBoard = this.needsPlayerBoard(ii);
            if (needsPlayerBoard) {
                this._boards[ii] = this.newBoard(ii);
                this._boards[ii].initializeSeed(seed);
                if (summaries != null) {
                    summaries[ii] = this.newBoardSummary(this._boards[ii]);
                }
            }
            ++ii;
        }
        this._puzobj.setSummaries(summaries);
    }

    protected boolean needsPlayerBoard(int pidx) {
        return this._puzobj.isOccupiedPlayer(pidx);
    }

    protected void gameDidEnd() {
        if (this._statusInterval != null) {
            this._statusInterval.cancel();
            this._statusInterval = null;
        }
        this.sendStatusUpdate();
        super.gameDidEnd();
    }

    protected void didShutdown() {
        super.didShutdown();
        if (this._statusInterval != null) {
            this._statusInterval.cancel();
            this._statusInterval = null;
        }
    }

    protected void applyProgressEvents(int pidx, int[] gevents, Board[] states) {
        int size = gevents.length;
        boolean before = this.compareBeforeApply();
        int ii = 0;
        while (ii < size) {
            Board cboard;
            int gevent = gevents[ii];
            Board board = cboard = states == null ? null : states[ii];
            if (before && cboard != null) {
                this.compareBoards(pidx, cboard, gevent, before);
            }
            this._boards[pidx].seedFromEvent(pidx, gevent);
            if (!this.applyProgressEvent(pidx, gevent, cboard)) {
                Log.log.warning((Object)"Unknown event", new Object[]{"puzzle", this.where(), "pidx", pidx, "event", gevent});
            }
            if (!before && cboard != null) {
                this.compareBoards(pidx, cboard, gevent, before);
            }
            ++ii;
        }
    }

    protected void compareBoards(int pidx, Board boardstate, int gevent, boolean before) {
        if (boardstate == null) {
            return;
        }
        boolean equal = this._boards[pidx].equals(boardstate);
        if (!equal) {
            Log.log.warning((Object)"Client and server board states not equal!", new Object[]{"game", this._puzobj.which(), "type", this._puzobj.getClass().getName()});
        }
        if (!equal) {
            this._boards[pidx].dumpAndCompare(boardstate);
        }
    }

    protected boolean applyProgressEvent(int pidx, int gevent, Board cboard) {
        return false;
    }

    protected void assignWinners(boolean[] winners) {
        int ii = 0;
        while (ii < winners.length) {
            winners[ii] = this._puzobj.isActivePlayer(ii);
            ++ii;
        }
    }

    protected abstract Board newBoard(int var1);

    protected abstract BoardSummary newBoardSummary(Board var1);

    public void updateProgress(ClientObject caller, int sessionId, int[] events) {
        this.updateProgressSync(caller, sessionId, events, null);
    }

    public void updateProgressSync(ClientObject caller, int sessionId, int[] events, Board[] states) {
        if (sessionId != this._puzobj.sessionId) {
            if (sessionId != this._puzobj.sessionId - 1) {
                Log.log.warning((Object)"Received progress update for invalid session, not applying", new Object[]{"game", this._puzobj.which(), "invalidSessionId", sessionId, "sessionId", this._puzobj.sessionId});
            }
            return;
        }
        if (!this._puzobj.isInPlay()) {
            Log.log.debug((Object)"Ignoring straggling events", new Object[]{"game", this._puzobj.which(), "who", caller.who(), "events", events});
            return;
        }
        int pidx = IntListUtil.indexOf((int[])this._playerOids, (int)caller.getOid());
        if (pidx == -1) {
            Log.log.warning((Object)"Received progress update for non-player?!", new Object[]{"game", this._puzobj.which(), "who", caller.who(), "ploids", this._playerOids});
            return;
        }
        this._lastProgress[pidx] = System.currentTimeMillis();
        this.applyProgressEvents(pidx, events, states);
    }

    protected void tick(long tickStamp) {
        super.tick(tickStamp);
        if (this._puzobj != null && this._puzobj.isInPlay() && this.checkForInactivity()) {
            int pcount = this.getPlayerSlots();
            int ii = 0;
            while (ii < pcount && this._puzobj.isInPlay()) {
                if (!this.isAI(ii)) {
                    this.checkPlayerActivity(tickStamp, ii);
                }
                ++ii;
            }
        }
    }

    protected boolean checkForInactivity() {
        return false;
    }

    protected void checkPlayerActivity(long tickStamp, int pidx) {
    }
}

