/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.puzzle.drop.util;

import com.samskivert.util.StringUtil;
import com.threerings.puzzle.Log;
import com.threerings.puzzle.drop.data.DropBoard;
import com.threerings.puzzle.drop.data.DropPieceCodes;
import com.threerings.puzzle.drop.util.PieceDropLogic;

public class PieceDropper
implements DropPieceCodes {
    protected PieceDropLogic _logic;

    public PieceDropper(PieceDropLogic logic) {
        this._logic = logic;
    }

    public int dropPieces(DropBoard board, DropObserver drobs) {
        int dropped = 0;
        int bhei = board.getHeight();
        int bwid = board.getWidth();
        int yy = bhei - 1;
        while (yy >= 0) {
            int xx = 0;
            while (xx < bwid) {
                dropped += this.dropPieces(board, xx, yy, drobs);
                ++xx;
            }
            --yy;
        }
        if (this._logic.boardAlwaysFilled()) {
            dropped += this.fillBoard(board, drobs);
        }
        return dropped;
    }

    public int fillBoard(DropBoard board, DropObserver drobs) {
        int dropped = 0;
        int bwid = board.getWidth();
        int xx = 0;
        while (xx < bwid) {
            int dist = board.getDropDistance(xx, -1);
            int ii = 0;
            while (ii < dist) {
                int yy = -1 - ii;
                int piece = board.getNextPiece();
                if (piece != -1) {
                    this.drop(board, piece, xx, yy, yy + dist, drobs);
                    ++dropped;
                }
                ++ii;
            }
            ++xx;
        }
        return dropped;
    }

    protected int dropPieces(DropBoard board, int xx, int yy, DropObserver drobs) {
        int piece = board.getPiece(xx, yy);
        if (!this._logic.isDroppablePiece(piece)) {
            return 0;
        }
        int dropped = 0;
        if (this._logic.isConstrainedPiece(piece)) {
            int start = this._logic.getConstrainedEdge(board, xx, yy, 0);
            int end = this._logic.getConstrainedEdge(board, xx, yy, 1);
            int bwid = board.getWidth();
            if (start < 0 || end >= bwid) {
                Log.log.warning((Object)"Board reported bogus constrained edge", new Object[]{"x", xx, "y", yy, "start", start, "end", end});
                board.dump();
                start = Math.max(start, 0);
                end = Math.min(end, bwid);
            }
            int dist = board.getHeight() - 1;
            int xpos = start;
            while (xpos <= end) {
                dist = Math.min(dist, board.getDropDistance(xpos, yy));
                ++xpos;
            }
            if (dist == 0) {
                return 0;
            }
            xpos = start;
            while (xpos <= end) {
                piece = board.getPiece(xpos, yy);
                this.drop(board, piece, xpos, yy, yy + dist, drobs);
                ++dropped;
                ++xpos;
            }
        } else {
            int dist = board.getDropDistance(xx, yy);
            if (dist == 0) {
                return 0;
            }
            this.drop(board, piece, xx, yy, yy + dist, drobs);
            ++dropped;
        }
        return dropped;
    }

    protected final void drop(DropBoard board, int piece, int xx, int yy, int ty, DropObserver drobs) {
        if (yy >= 0) {
            board.setPiece(xx, yy, -1);
        }
        board.setPiece(xx, ty, piece);
        if (drobs != null) {
            drobs.pieceDropped(piece, xx, yy, xx, ty);
        }
    }

    public static interface DropObserver {
        public void pieceDropped(int var1, int var2, int var3, int var4, int var5);
    }

    public static class PieceDropInfo {
        public int row;
        public int col;
        public int dist;
        public int[] pieces;

        public PieceDropInfo(int col, int row, int dist) {
            this.col = col;
            this.row = row;
            this.dist = dist;
        }

        public String toString() {
            return StringUtil.fieldsToString((Object)this);
        }
    }
}

