/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.puzzle.drop.util;

import com.google.common.collect.Lists;
import com.threerings.puzzle.drop.data.DropBoard;
import com.threerings.puzzle.drop.data.DropPieceCodes;
import com.threerings.puzzle.drop.data.SegmentInfo;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PieceDestroyer
implements DropPieceCodes {
    protected DestroyLogic _logic;
    protected SegmentLengthOperation _lengthOp = new SegmentLengthOperation();
    protected List<SegmentInfo> _destroyed = Lists.newArrayList();

    public PieceDestroyer(DestroyLogic logic) {
        this._logic = logic;
    }

    public List<SegmentInfo> destroyPieces(DropBoard board, DropBoard.PieceOperation destroyOp) {
        int bwid = board.getWidth();
        int bhei = board.getHeight();
        this._destroyed.clear();
        int end = bwid - this._logic.getMinimumLength() + 1;
        int yy = bhei - 1;
        while (yy >= 0) {
            int xx = 0;
            while (xx < end) {
                xx += this.findSegment(board, 0, xx, yy);
            }
            --yy;
        }
        end = this._logic.getMinimumLength() - 2;
        int xx = 0;
        while (xx < bwid) {
            int yy2 = bhei - 1;
            while (yy2 > end) {
                yy2 -= this.findSegment(board, 1, xx, yy2);
            }
            ++xx;
        }
        int size = this._destroyed.size();
        int ii = 0;
        while (ii < size) {
            SegmentInfo si = this._destroyed.get(ii);
            board.applyOp(si.dir, si.x, si.y, si.len, destroyOp);
            ++ii;
        }
        return this._destroyed;
    }

    protected int findSegment(DropBoard board, int dir, int x, int y) {
        this._lengthOp.reset();
        board.applyOp(dir, x, y, this._lengthOp);
        int len = this._lengthOp.getLength();
        if (len >= this._logic.getMinimumLength()) {
            this._destroyed.add(new SegmentInfo(dir, x, y, len));
        }
        return len;
    }

    public static interface DestroyLogic {
        public int getMinimumLength();

        public boolean isEquivalent(int var1, int var2);
    }

    protected class SegmentLengthOperation
    implements DropBoard.PieceOperation {
        protected int _piece;
        protected int _len;

        protected SegmentLengthOperation() {
        }

        public void reset() {
            this._len = 0;
        }

        public int getLength() {
            return this._len;
        }

        public boolean execute(DropBoard board, int col, int row) {
            int piece = board.getPiece(col, row);
            if (this._len == 0) {
                this._len = 1;
                this._piece = piece;
                return piece != -1;
            }
            if (PieceDestroyer.this._logic.isEquivalent(piece, this._piece)) {
                ++this._len;
                return true;
            }
            return false;
        }
    }
}

