/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.parlor.server;

import com.google.common.base.Preconditions;
import com.samskivert.util.IntMap;
import com.samskivert.util.IntMaps;
import com.samskivert.util.ListUtil;
import com.threerings.crowd.data.BodyObject;
import com.threerings.crowd.data.PlaceConfig;
import com.threerings.crowd.data.PlaceObject;
import com.threerings.crowd.server.PlaceRegistry;
import com.threerings.parlor.Log;
import com.threerings.parlor.data.ParlorCodes;
import com.threerings.parlor.data.Table;
import com.threerings.parlor.data.TableConfig;
import com.threerings.parlor.data.TableLobbyObject;
import com.threerings.parlor.data.TableMarshaller;
import com.threerings.parlor.game.data.GameConfig;
import com.threerings.parlor.game.data.GameObject;
import com.threerings.parlor.game.server.GameManager;
import com.threerings.parlor.server.TableProvider;
import com.threerings.presents.client.InvocationService;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.data.InvocationMarshaller;
import com.threerings.presents.dobj.AttributeChangeListener;
import com.threerings.presents.dobj.AttributeChangedEvent;
import com.threerings.presents.dobj.ChangeListener;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.NamedEvent;
import com.threerings.presents.dobj.ObjectAddedEvent;
import com.threerings.presents.dobj.ObjectDeathListener;
import com.threerings.presents.dobj.ObjectDestroyedEvent;
import com.threerings.presents.dobj.ObjectRemovedEvent;
import com.threerings.presents.dobj.OidListListener;
import com.threerings.presents.dobj.RootDObjectManager;
import com.threerings.presents.server.InvocationException;
import com.threerings.presents.server.InvocationManager;
import com.threerings.presents.server.InvocationProvider;
import com.threerings.util.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableManager
implements ParlorCodes,
TableProvider {
    protected ChangeListener _placeListener = new OidListListener(){

        public void objectAdded(ObjectAddedEvent event) {
        }

        public void objectRemoved(ObjectRemovedEvent event) {
            if (event.getName().equals("occupants")) {
                TableManager.this.bodyLeft(event.getOid());
            }
        }
    };
    protected DObject _dobj;
    protected TableLobbyObject _tlobj;
    protected Class<? extends Table> _tableClass = Table.class;
    protected IntMap<Table> _tables = IntMaps.newHashIntMap();
    protected IntMap<Table> _boidMap = IntMaps.newHashIntMap();
    protected IntMap<Table> _goidMap = IntMaps.newHashIntMap();
    protected ChangeListener _gameListener = new GameListener();
    protected ChangeListener _userListener = new UserListener();
    protected boolean _allowBooting = false;
    protected RootDObjectManager _omgr;
    protected InvocationManager _invmgr;
    protected PlaceRegistry _plreg;

    public TableManager(RootDObjectManager omgr, InvocationManager invmgr, PlaceRegistry plreg, DObject tableObject) {
        this._omgr = omgr;
        this._invmgr = invmgr;
        this._plreg = plreg;
        if (tableObject != null) {
            this.setTableObject(tableObject);
        }
    }

    public void setTableObject(DObject tableObject) {
        Preconditions.checkState((this._tlobj == null ? 1 : 0) != 0, (Object)"Already got one!");
        this._tlobj = (TableLobbyObject)tableObject;
        this._tlobj.setTableService((TableMarshaller)this._invmgr.registerProvider((InvocationProvider)this, TableMarshaller.class));
        this._dobj = tableObject;
        if (this._dobj instanceof PlaceObject) {
            this._dobj.addListener(this._placeListener);
        }
    }

    public int getTableCount() {
        return this._tables.size();
    }

    public void shutdown() {
        if (this._tlobj != null) {
            this._invmgr.clearDispatcher((InvocationMarshaller)this._tlobj.getTableService());
            this._tlobj.setTableService(null);
        }
        if (this._dobj instanceof PlaceObject) {
            this._dobj.removeListener(this._placeListener);
        }
        this._tlobj = null;
        this._dobj = null;
    }

    public void setTableClass(Class<? extends Table> tableClass) {
        this._tableClass = tableClass;
    }

    public void setAllowBooting(boolean allowBooting) {
        this._allowBooting = allowBooting;
    }

    public Table createTable(BodyObject creator, TableConfig tableConfig, GameConfig config) throws InvocationException {
        Table table;
        if (this._boidMap.containsKey(creator.getOid())) {
            throw new InvocationException("m.already_at_table");
        }
        try {
            table = this._tableClass.newInstance();
        }
        catch (Exception e) {
            Log.log.warning((Object)"Table.newInstance() failed", new Object[]{"class", this._tableClass, e});
            throw new InvocationException("m.internal_error");
        }
        table.init(this._dobj.getOid(), tableConfig, config);
        if (table.bodyOids != null && table.bodyOids.length > 0) {
            int cpos = config.ais == null ? 0 : config.ais.length;
            String error = table.setPlayer(cpos, creator);
            if (error != null) {
                Log.log.warning((Object)"Unable to add creator to position zero of table!?", new Object[]{"table", table, "creator", creator, "error", error});
                throw new InvocationException(error);
            }
            this.notePlayerAdded(table, creator);
        }
        this._tables.put(table.tableId, (Object)table);
        if (table.shouldBeStarted()) {
            this.createGame(table);
        }
        this.tableCreated(table);
        return table;
    }

    @Override
    public void createTable(ClientObject caller, TableConfig tableConfig, GameConfig config, InvocationService.ResultListener listener) throws InvocationException {
        BodyObject creator = (BodyObject)caller;
        if (this._dobj instanceof PlaceObject && !((PlaceObject)this._dobj).occupants.contains(creator.getOid())) {
            Log.log.warning((Object)"Requested to create a table in a place not occupied by the creator", new Object[]{"creator", creator, "ploid", this._dobj.getOid()});
            throw new InvocationException("m.internal_error");
        }
        listener.requestProcessed((Object)this.createTable((BodyObject)creator, (TableConfig)tableConfig, (GameConfig)config).tableId);
    }

    @Override
    public void joinTable(ClientObject caller, int tableId, int position, InvocationService.InvocationListener listener) throws InvocationException {
        BodyObject joiner = (BodyObject)caller;
        if (this._boidMap.containsKey(joiner.getOid())) {
            throw new InvocationException("m.already_at_table");
        }
        Table table = (Table)this._tables.get(tableId);
        if (table == null) {
            throw new InvocationException("m.no_such_table");
        }
        String error = table.setPlayer(position, joiner);
        if (error != null) {
            throw new InvocationException(error);
        }
        if (table.shouldBeStarted()) {
            this.createGame(table);
        } else {
            this.notePlayerAdded(table, joiner);
        }
        this.updateTableInLobby(table);
    }

    @Override
    public void leaveTable(ClientObject caller, int tableId, InvocationService.InvocationListener listener) throws InvocationException {
        BodyObject leaver = (BodyObject)caller;
        Table table = (Table)this._tables.get(tableId);
        if (table == null) {
            throw new InvocationException("m.no_such_table");
        }
        if (table.inPlay()) {
            throw new InvocationException("m.game_already_started");
        }
        if (!table.clearPlayer(leaver.getVisibleName())) {
            throw new InvocationException("m.not_at_table");
        }
        if (this.notePlayerRemoved(leaver.getOid(), leaver) == null) {
            Log.log.warning((Object)"No body to table mapping to clear?", new Object[]{"leaver", leaver.who(), "table", table});
        }
        if (table.isEmpty()) {
            this.purgeTable(table);
        } else {
            this.updateTableInLobby(table);
        }
    }

    @Override
    public void startTableNow(ClientObject caller, int tableId, InvocationService.InvocationListener listener) throws InvocationException {
        BodyObject starter = (BodyObject)caller;
        Table table = (Table)this._tables.get(tableId);
        if (table == null) {
            throw new InvocationException("m.no_such_table");
        }
        if (starter.getOid() != table.bodyOids[0]) {
            throw new InvocationException("m.must_be_creator");
        }
        if (!table.mayBeStarted()) {
            throw new InvocationException("m.internal_error");
        }
        this.createGame(table);
    }

    @Override
    public void bootPlayer(ClientObject caller, int tableId, Name target, InvocationService.InvocationListener listener) throws InvocationException {
        BodyObject booter = (BodyObject)caller;
        Table table = (Table)this._tables.get(tableId);
        if (table == null) {
            throw new InvocationException("m.no_such_table");
        }
        if (!this._allowBooting) {
            throw new InvocationException("m.internal_error");
        }
        int position = ListUtil.indexOf((Object[])table.players, (Object)target);
        if (position < 0) {
            throw new InvocationException("m.not_at_table");
        }
        if (booter.getOid() != table.bodyOids[0]) {
            throw new InvocationException("m.must_be_creator");
        }
        if (booter.getOid() == table.bodyOids[position]) {
            throw new InvocationException("m.no_self_boot");
        }
        table.addBannedUser(target);
        if (this.notePlayerRemoved(table.bodyOids[position]) == null) {
            Log.log.warning((Object)"No body to table mapping to clear?", new Object[]{"position", position, "table", table});
        }
        table.clearPlayerPos(position);
        this.updateTableInLobby(table);
    }

    protected void tableCreated(Table table) {
        if (this.shouldPublish(table)) {
            this.addTableToLobby(table);
        }
    }

    protected void purgeTable(Table table) {
        DObject gameObj;
        this._tables.remove(table.tableId);
        if (table.bodyOids != null) {
            int[] nArray = table.bodyOids;
            int n = table.bodyOids.length;
            int n2 = 0;
            while (n2 < n) {
                int bodyOid = nArray[n2];
                if (bodyOid != 0) {
                    this.notePlayerRemoved(bodyOid);
                }
                ++n2;
            }
        }
        Table removed = (Table)this._goidMap.remove(table.gameOid);
        this.removeTableFromLobby(table.tableId);
        if (removed != null && (gameObj = this._omgr.getObject(table.gameOid)) != null) {
            gameObj.removeListener(this._gameListener);
        }
    }

    protected void notePlayerAdded(Table table, BodyObject body) {
        this._boidMap.put(body.getOid(), (Object)table);
        body.addListener(this._userListener);
    }

    protected final Table notePlayerRemoved(int playerOid) {
        return this.notePlayerRemoved(playerOid, (BodyObject)this._omgr.getObject(playerOid));
    }

    protected Table notePlayerRemoved(int playerOid, BodyObject body) {
        if (body != null) {
            body.removeListener(this._userListener);
        }
        return (Table)this._boidMap.remove(playerOid);
    }

    protected int createGame(Table table) throws InvocationException {
        try {
            GameManager gmgr = this.createGameManager(this.createConfig(table));
            GameObject gobj = (GameObject)gmgr.getPlaceObject();
            this.gameCreated(table, gobj, gmgr);
            return gobj.getOid();
        }
        catch (Throwable t) {
            Log.log.warning((Object)"Failed to create manager for game", new Object[]{"config", table.config, t});
            throw new InvocationException("m.internal_error");
        }
    }

    protected GameConfig createConfig(Table table) {
        table.config.players = table.getPlayers();
        return table.config;
    }

    protected GameManager createGameManager(GameConfig config) throws InstantiationException, InvocationException {
        return (GameManager)this._plreg.createPlace((PlaceConfig)config);
    }

    protected void gameCreated(Table table, GameObject gameobj, GameManager gmgr) {
        table.gameOid = gameobj.getOid();
        this._goidMap.put(table.gameOid, (Object)table);
        gameobj.setIsPrivate(table.tconfig.privateTable);
        if (table.bodyOids != null) {
            int[] nArray = table.bodyOids;
            int n = table.bodyOids.length;
            int n2 = 0;
            while (n2 < n) {
                int bodyOid = nArray[n2];
                if (bodyOid != 0) {
                    this.notePlayerRemoved(bodyOid);
                }
                ++n2;
            }
        }
        gameobj.addListener(this._gameListener);
        if (this.shouldPublish(table)) {
            this.updateTableInLobby(table);
        } else {
            this.removeTableFromLobby(table.tableId);
        }
    }

    protected void unmapTable(int gameOid) {
        if (this._tlobj == null) {
            return;
        }
        Table table = (Table)this._goidMap.get(gameOid);
        if (table != null) {
            this.purgeTable(table);
        } else {
            Log.log.warning((Object)"Requested to unmap table that wasn't mapped", new Object[]{"gameOid", gameOid});
        }
    }

    protected void updateOccupants(int gameOid) {
        if (this._tlobj == null) {
            return;
        }
        Table table = (Table)this._goidMap.get(gameOid);
        if (table == null) {
            Log.log.warning((Object)"Unable to find table for running game", new Object[]{"gameOid", gameOid});
            return;
        }
        GameObject gameObj = (GameObject)this._omgr.getObject(gameOid);
        table.updateOccupants(gameObj);
        this.updateTableInLobby(table);
    }

    protected void bodyLeft(int bodyOid) {
        Table pender = this.notePlayerRemoved(bodyOid);
        if (pender == null) {
            return;
        }
        if (!pender.clearPlayerByOid(bodyOid)) {
            Log.log.warning((Object)"Attempt to remove body from mapped table failed", new Object[]{"table", pender, "bodyOid", bodyOid});
            return;
        }
        if (pender.isEmpty()) {
            this.purgeTable(pender);
        } else {
            this.updateTableInLobby(pender);
        }
    }

    protected boolean shouldPublish(Table table) {
        return true;
    }

    protected void addTableToLobby(Table table) {
        this._tlobj.addToTables(table);
    }

    protected void updateTableInLobby(Table table) {
        if (this._tlobj.getTables().containsKey((Comparable)Integer.valueOf(table.tableId))) {
            this._tlobj.updateTables(table);
        }
    }

    protected void removeTableFromLobby(Integer tableId) {
        if (this._tlobj.getTables().containsKey((Comparable)tableId)) {
            this._tlobj.removeFromTables(tableId);
        }
    }

    protected class GameListener
    implements ObjectDeathListener,
    OidListListener {
        protected GameListener() {
        }

        public void objectDestroyed(ObjectDestroyedEvent event) {
            TableManager.this.unmapTable(event.getTargetOid());
        }

        public void objectAdded(ObjectAddedEvent event) {
            this.maybeCheckOccupants((NamedEvent)event);
        }

        public void objectRemoved(ObjectRemovedEvent event) {
            this.maybeCheckOccupants((NamedEvent)event);
        }

        protected void maybeCheckOccupants(NamedEvent event) {
            if ("occupants".equals(event.getName())) {
                TableManager.this.updateOccupants(event.getTargetOid());
            }
        }
    }

    protected class UserListener
    implements AttributeChangeListener,
    ObjectDeathListener {
        protected UserListener() {
        }

        public void attributeChanged(AttributeChangedEvent event) {
            if ("status".equals(event.getName()) && event.getByteValue() == 2) {
                TableManager.this.bodyLeft(event.getTargetOid());
            }
        }

        public void objectDestroyed(ObjectDestroyedEvent event) {
            TableManager.this.bodyLeft(event.getTargetOid());
        }
    }
}

