/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.parlor.server;

import com.google.inject.Inject;
import com.samskivert.util.IntMap;
import com.samskivert.util.IntMaps;
import com.threerings.crowd.data.BodyObject;
import com.threerings.crowd.data.PlaceConfig;
import com.threerings.crowd.server.BodyLocator;
import com.threerings.crowd.server.PlaceRegistry;
import com.threerings.parlor.Log;
import com.threerings.parlor.client.ParlorService;
import com.threerings.parlor.data.ParlorCodes;
import com.threerings.parlor.data.ParlorMarshaller;
import com.threerings.parlor.game.data.GameConfig;
import com.threerings.parlor.server.ParlorProvider;
import com.threerings.parlor.server.ParlorSender;
import com.threerings.presents.client.InvocationService;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.server.InvocationException;
import com.threerings.presents.server.InvocationManager;
import com.threerings.presents.server.InvocationProvider;
import com.threerings.util.Name;

public class ParlorManager
implements ParlorCodes,
ParlorProvider {
    @Inject
    protected PlaceRegistry _plreg;
    @Inject
    protected BodyLocator _locator;
    protected IntMap<Invitation> _invites = IntMaps.newHashIntMap();
    protected static int _nextInviteId = 0;

    @Inject
    public ParlorManager(InvocationManager invmgr) {
        invmgr.registerProvider((InvocationProvider)this, ParlorMarshaller.class, "parlor");
    }

    public void invite(ClientObject caller, Name invitee, GameConfig config, ParlorService.InviteListener listener) throws InvocationException {
        BodyObject source = (BodyObject)caller;
        BodyObject target = this._locator.lookupBody(invitee);
        if (target == null) {
            throw new InvocationException("m.invitee_not_online");
        }
        int inviteId = this.invite(source, target, config);
        listener.inviteReceived(inviteId);
    }

    public void respond(ClientObject caller, int inviteId, int code, Object arg, InvocationService.InvocationListener listener) {
        this.respondToInvite((BodyObject)caller, inviteId, code, arg);
    }

    public void cancel(ClientObject caller, int inviteId, InvocationService.InvocationListener listener) {
        this.cancelInvite((BodyObject)caller, inviteId);
    }

    public void startSolitaire(ClientObject caller, GameConfig config, InvocationService.ConfirmListener listener) throws InvocationException {
        BodyObject user = (BodyObject)caller;
        Log.log.debug((Object)("Processing start solitaire [caller=" + user.who() + ", config=" + config + "]."), new Object[0]);
        try {
            if (config.players == null || config.players.length == 0) {
                config.players = new Name[]{user.getVisibleName()};
            }
            this.createGameManager(config);
            listener.requestProcessed();
        }
        catch (InstantiationException ie) {
            Log.log.warning((Object)("Error instantiating game manager [for=" + caller.who() + ", config=" + config + "]."), new Object[]{ie});
            throw new InvocationException("m.internal_error");
        }
    }

    public int invite(BodyObject inviter, BodyObject invitee, GameConfig config) throws InvocationException {
        Invitation invite = new Invitation(inviter, invitee, config);
        this._invites.put(invite.inviteId, (Object)invite);
        ParlorSender.sendInvite((ClientObject)invitee, invite.inviteId, inviter.getVisibleName(), config);
        return invite.inviteId;
    }

    public void respondToInvite(BodyObject source, int inviteId, int code, Object arg) {
        Invitation invite = (Invitation)this._invites.get(inviteId);
        if (invite == null) {
            Log.log.warning((Object)("Requested to respond to non-existent invitation [source=" + source + ", inviteId=" + inviteId + ", code=" + code + ", arg=" + arg + "]."), new Object[0]);
            return;
        }
        if (source != invite.invitee) {
            Log.log.warning((Object)("Got response from non-invitee [source=" + source + ", invite=" + invite + ", code=" + code + ", arg=" + arg + "]."), new Object[0]);
            return;
        }
        ParlorSender.sendInviteResponse((ClientObject)invite.inviter, invite.inviteId, code, arg);
        switch (code) {
            case 0: {
                this.processAcceptedInvitation(invite);
                this._invites.remove(inviteId);
                break;
            }
            case 1: {
                this._invites.remove(inviteId);
                break;
            }
            case 2: {
                invite.swapControl();
                break;
            }
            default: {
                Log.log.warning((Object)("Requested to respond to invitation with unknown response code [source=" + source + ", invite=" + invite + ", code=" + code + ", arg=" + arg + "]."), new Object[0]);
            }
        }
    }

    public void cancelInvite(BodyObject source, int inviteId) {
    }

    protected void processAcceptedInvitation(Invitation invite) {
        try {
            Log.log.info((Object)("Creating game manager [invite=" + invite + "]."), new Object[0]);
            invite.config.players = new Name[]{invite.invitee.getVisibleName(), invite.inviter.getVisibleName()};
            this.createGameManager(invite.config);
        }
        catch (Exception e) {
            Log.log.warning((Object)("Unable to create game manager [invite=" + invite + "]."), new Object[]{e});
        }
    }

    protected void createGameManager(GameConfig config) throws InstantiationException, InvocationException {
        this._plreg.createPlace((PlaceConfig)config);
    }

    protected static class Invitation {
        public int inviteId = _nextInviteId++;
        public BodyObject inviter;
        public BodyObject invitee;
        public GameConfig config;

        public Invitation(BodyObject inviter, BodyObject invitee, GameConfig config) {
            this.inviter = inviter;
            this.invitee = invitee;
            this.config = config;
        }

        public void swapControl() {
            BodyObject tmp = this.inviter;
            this.inviter = this.invitee;
            this.invitee = tmp;
        }
    }
}

