/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.micasa.simulator.client;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.samskivert.swing.util.SwingUtil;
import com.samskivert.util.Interval;
import com.samskivert.util.ResultListener;
import com.threerings.crowd.server.CrowdServer;
import com.threerings.micasa.Log;
import com.threerings.micasa.simulator.client.SimpleClient;
import com.threerings.micasa.simulator.client.SimpleFrame;
import com.threerings.micasa.simulator.client.SimulatorClient;
import com.threerings.micasa.simulator.client.SimulatorController;
import com.threerings.micasa.simulator.client.SimulatorFrame;
import com.threerings.micasa.simulator.data.SimulatorInfo;
import com.threerings.micasa.simulator.server.SimpleServer;
import com.threerings.micasa.simulator.server.SimulatorServer;
import com.threerings.presents.client.Client;
import com.threerings.presents.client.ClientAdapter;
import com.threerings.presents.client.SessionObserver;
import com.threerings.presents.net.Credentials;
import com.threerings.presents.net.UsernamePasswordCreds;
import com.threerings.util.Name;
import java.awt.Window;
import javax.swing.JFrame;

public class SimulatorApp {
    protected SimulatorClient _client;
    protected SimulatorFrame _frame;
    protected ServerThread _serverThread;
    protected static final int DEFAULT_PLAYER_COUNT = 2;

    public void start(String[] args) throws Exception {
        this._frame = this.createSimulatorFrame();
        SimulatorInfo siminfo = new SimulatorInfo();
        siminfo.gameConfigClass = args[0];
        siminfo.simClass = args[1];
        siminfo.playerCount = this.getInt(System.getProperty("playercount"), 2);
        this._client = this.createSimulatorClient(this._frame);
        SimulatorController ctrl = this.createController(siminfo);
        this._frame.setController(ctrl);
        Injector injector = Guice.createInjector((Module[])new Module[]{new CrowdServer.CrowdModule()});
        SimulatorServer server = this.createSimulatorServer(injector);
        server.init(injector, new ResultListener<SimulatorServer>(){

            public void requestCompleted(SimulatorServer result) {
                try {
                    SimulatorApp.this.run();
                }
                catch (Exception e) {
                    Log.log.warning((Object)("Simulator initialization failed [e=" + e + "]."), new Object[0]);
                }
            }

            public void requestFailed(Exception e) {
                Log.log.warning((Object)("Simulator initialization failed [e=" + e + "]."), new Object[0]);
            }
        });
        this._serverThread = new ServerThread(server);
        this._serverThread.start();
    }

    protected SimulatorServer createSimulatorServer(Injector injector) {
        return (SimulatorServer)injector.getInstance(SimpleServer.class);
    }

    protected SimulatorFrame createSimulatorFrame() {
        return new SimpleFrame();
    }

    protected SimulatorClient createSimulatorClient(SimulatorFrame frame) throws Exception {
        return new SimpleClient(this._frame);
    }

    protected SimulatorController createController(SimulatorInfo siminfo) {
        return new SimulatorController(this._client.getParlorContext(), this._frame, siminfo);
    }

    public void run() {
        String password;
        JFrame frame = this._frame.getFrame();
        frame.setSize(800, 600);
        SwingUtil.centerWindow((Window)frame);
        frame.setVisible(true);
        Client client = this._client.getParlorContext().getClient();
        Log.log.info((Object)"Connecting to localhost.", new Object[0]);
        client.setServer("localhost", Client.DEFAULT_SERVER_PORTS);
        client.addClientObserver((SessionObserver)new ClientAdapter(){

            public void clientFailedToLogon(Client c, Exception cause) {
                Log.log.info((Object)("Client failed to logon: " + cause), new Object[0]);
                System.exit(0);
            }

            public void clientDidLogoff(Client c) {
                System.exit(0);
            }
        });
        String username = System.getProperty("username");
        if (username == null) {
            username = "bob" + (int)(Math.random() * 2.147483647E9) % 500;
        }
        if ((password = System.getProperty("password")) == null) {
            password = "test";
        }
        client.setCredentials((Credentials)new UsernamePasswordCreds(new Name(username), password));
        new Interval(Interval.RUN_DIRECT){

            public void expired() {
                SimulatorApp.this._client.getParlorContext().getClient().logon();
            }
        }.schedule(500L);
    }

    public static void main(String[] args) {
        if (!SimulatorApp.checkArgs(args)) {
            return;
        }
        SimulatorApp app = new SimulatorApp();
        try {
            app.start(args);
        }
        catch (Exception e) {
            Log.log.warning((Object)"Error starting up application.", new Object[]{e});
        }
    }

    protected static boolean checkArgs(String[] args) {
        if (args.length < 2) {
            String msg = "Usage:\n    java com.threerings.simulator.SimulatorApp <game config class name> <simulant class name>\nOptional properties:\n    -Dusername=<user>\n    -Dplayercount=<number>\n    -Dwidth=<width>\n    -Dheight=<height>";
            System.out.println(msg);
            return false;
        }
        return true;
    }

    protected int getInt(String value, int defval) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            return defval;
        }
    }

    protected static class ServerThread
    extends Thread {
        protected SimulatorServer _server;

        public ServerThread(SimulatorServer server) {
            this._server = server;
        }

        public void run() {
            this._server.run();
        }
    }
}

