//
// $Id$
//
// Vilya library - tools for developing networked games
// Copyright (C) 2002-2012 Three Rings Design, Inc., All Rights Reserved
// http://code.google.com/p/vilya/
//
// This library is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License as published
// by the Free Software Foundation; either version 2.1 of the License, or
// (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

package com.threerings.micasa.client;

import java.io.IOException;

import com.samskivert.swing.util.SwingUtil;

import com.threerings.util.Name;

import com.threerings.presents.client.Client;
import com.threerings.presents.net.UsernamePasswordCreds;

import static com.threerings.micasa.Log.log;

/**
 * The micasa app is the main point of entry for the MiCasa client application. It creates and
 * initializes the myriad components of the client and sets all the proper wheels in motion.
 */
public class MiCasaApp
{
    public void init ()
        throws IOException
    {
        // create a frame
        _frame = new MiCasaFrame();

        // create our client instance
        String cclass = null;
        try {
            cclass = System.getProperty("client");
        } catch (Throwable t) {
            // security manager in effect, no problem
        }
        if (cclass == null) {
            cclass = MiCasaClient.class.getName();
        }

        try {
            _client = (MiCasaClient)Class.forName(cclass).newInstance();
        } catch (Exception e) {
            log.warning("Unable to instantiate client class", "cclass", cclass, e);
        }

        // initialize our client instance
        _client.init(_frame);
    }

    public void run (String server, String username, String password)
    {
        // position everything and show the frame
        _frame.setSize(800, 600);
        SwingUtil.centerWindow(_frame);
        _frame.setVisible(true);

        Client client = _client.getContext().getClient();

        log.info("Using", "server", server);
        client.setServer(server, Client.DEFAULT_SERVER_PORTS);

        // configure the client with some credentials and logon
        if (username != null && password != null) {
            // create and set our credentials
            client.setCredentials(new UsernamePasswordCreds(new Name(username), password));
            client.logon();
        }
    }

    public static void main (String[] args)
    {
        String server = "localhost";
        if (args.length > 0) {
            server = args[0];
        }
        String username = (args.length > 1) ? args[1] : null;
        String password = (args.length > 2) ? args[2] : null;

        MiCasaApp app = new MiCasaApp();
        try {
            // initialize the app
            app.init();
        } catch (IOException ioe) {
            log.warning("Error initializing application.", ioe);
        }

        // and run it
        app.run(server, username, password);
    }

    protected MiCasaClient _client;
    protected MiCasaFrame _frame;
}
