/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.puzzle.drop.client;

import com.threerings.media.animation.Animation;
import com.threerings.media.sprite.PathObserver;
import com.threerings.media.sprite.Sprite;
import com.threerings.media.util.Path;
import com.threerings.puzzle.drop.client.DropBoardView;
import com.threerings.puzzle.drop.data.DropBoard;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public abstract class PieceGroupAnimation
extends Animation
implements PathObserver {
    protected DropBoardView _view;
    protected DropBoard _board;
    protected Sprite[] _sprites;
    protected int _penders;

    public PieceGroupAnimation(DropBoardView view, DropBoard board) {
        super(new Rectangle(0, 0, 0, 0));
        this._view = view;
        this._board = board;
    }

    public void tick(long tickStamp) {
    }

    public void paint(Graphics2D gfx) {
    }

    public void pathCancelled(Sprite sprite, Path path) {
        this._finished = --this._penders == 0;
    }

    public void pathCompleted(Sprite sprite, Path path, long when) {
        this._finished = --this._penders == 0;
    }

    protected void willStart(long tickStamp) {
        super.willStart(tickStamp);
        int width = this._board.getWidth();
        int height = this._board.getHeight();
        this._sprites = new Sprite[width * height];
        for (int yy = 0; yy < height; ++yy) {
            for (int xx = 0; xx < width; ++xx) {
                int spos = yy * width + xx;
                this._sprites[spos] = this._view.getPieceSprite(xx, yy);
                if (this._sprites[spos] == null) continue;
                this.configureSprite(this._sprites[spos], xx, yy);
                this._sprites[spos].addSpriteObserver((Object)this);
                ++this._penders;
            }
        }
    }

    protected abstract void configureSprite(Sprite var1, int var2, int var3);
}

