/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.parlor.turn.server;

import com.samskivert.util.RandomUtil;
import com.threerings.crowd.data.PlaceConfig;
import com.threerings.crowd.data.PlaceObject;
import com.threerings.parlor.Log;
import com.threerings.parlor.game.server.GameManagerDelegate;
import com.threerings.parlor.turn.data.TurnGameObject;
import com.threerings.parlor.turn.server.TurnGameManager;
import com.threerings.util.Name;

public class TurnGameManagerDelegate
extends GameManagerDelegate {
    protected TurnGameManager _tgmgr;
    protected TurnGameObject _turnGame;
    protected int _turnIdx = -1;

    public TurnGameManagerDelegate() {
    }

    @Deprecated
    public TurnGameManagerDelegate(TurnGameManager tgmgr) {
    }

    public int getTurnHolderIndex() {
        return this._tgmgr.getPlayerIndex(this._turnGame.getTurnHolder());
    }

    public boolean isPlayersTurn(int playerIndex) {
        int turnHolder = this.getTurnHolderIndex();
        if (turnHolder < 0) {
            return false;
        }
        return turnHolder == playerIndex;
    }

    public void startTurn() {
        if (this._turnIdx < 0 || this._turnIdx >= this._turnGame.getPlayers().length) {
            Log.log.warning((Object)"startTurn() called with invalid turn index", new Object[]{"game", this.where(), "turnIdx", this._turnIdx});
            return;
        }
        Name name = this._tgmgr.getPlayerName(this._turnIdx);
        if (name == null) {
            Log.log.warning((Object)("startTurn() called with invalid player [game=" + this.where() + ", turnIdx=" + this._turnIdx + "]."), new Object[0]);
            return;
        }
        this._tgmgr.turnWillStart();
        this._turnGame.setTurnHolder(name);
        this._tgmgr.turnDidStart();
    }

    public void endTurn() {
        this._tgmgr.turnDidEnd();
        this.setNextTurnHolder();
        if (this._turnGame.isInPlay() && this._turnIdx != -1) {
            this.startTurn();
        } else {
            this._turnGame.setTurnHolder(null);
        }
    }

    public void didInit(PlaceConfig config) {
        super.didInit(config);
        this._tgmgr = (TurnGameManager)this._plmgr;
    }

    public void didStartup(PlaceObject plobj) {
        this._turnGame = (TurnGameObject)plobj;
    }

    public void playerWasReplaced(int pidx, Name oplayer, Name nplayer) {
        if (oplayer != null && oplayer.equals((Object)this._turnGame.getTurnHolder())) {
            this._turnGame.setTurnHolder(TurnGameObject.TURN_HOLDER_REPLACED);
            this._turnGame.setTurnHolder(nplayer);
        }
    }

    public void gameDidStart() {
        this.setFirstTurnHolder();
        if (this._turnIdx != -1) {
            this.startTurn();
        }
    }

    protected void setFirstTurnHolder() {
        this.assignTurnRandomly();
    }

    protected void setNextTurnHolder() {
        if (this._tgmgr.getPlayerCount() <= 1) {
            return;
        }
        int size = this._turnGame.getPlayers().length;
        int oturnIdx = this._turnIdx;
        do {
            this._turnIdx = (this._turnIdx + 1) % size;
            if (this._turnIdx != oturnIdx) continue;
            Log.log.warning((Object)"1 or less active players. Unable to properly change turn.", new Object[]{"game", this.where()});
            break;
        } while (!this._tgmgr.isActivePlayer(this._turnIdx));
    }

    protected void assignTurnRandomly() {
        int size = this._turnGame.getPlayers().length;
        if (size > 0) {
            int firstPick = this._turnIdx = RandomUtil.getInt((int)size);
            while (!this._tgmgr.isActivePlayer(this._turnIdx)) {
                this._turnIdx = (this._turnIdx + 1) % size;
                if (this._turnIdx != firstPick) continue;
                Log.log.warning((Object)"No players eligible for randomly-assigned turn. Choking.", new Object[]{"game", this.where()});
                return;
            }
        }
    }
}

