/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.parlor.client;

import com.google.common.base.Objects;
import com.samskivert.util.ObserverList;
import com.threerings.crowd.data.BodyObject;
import com.threerings.parlor.Log;
import com.threerings.parlor.client.SeatednessObserver;
import com.threerings.parlor.client.TableObserver;
import com.threerings.parlor.data.Table;
import com.threerings.parlor.data.TableConfig;
import com.threerings.parlor.data.TableLobbyObject;
import com.threerings.parlor.game.data.GameConfig;
import com.threerings.parlor.util.ParlorContext;
import com.threerings.presents.client.BasicDirector;
import com.threerings.presents.client.Client;
import com.threerings.presents.client.InvocationService;
import com.threerings.presents.dobj.ChangeListener;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.EntryAddedEvent;
import com.threerings.presents.dobj.EntryRemovedEvent;
import com.threerings.presents.dobj.EntryUpdatedEvent;
import com.threerings.presents.dobj.SetListener;
import com.threerings.presents.util.PresentsContext;
import com.threerings.util.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableDirector
extends BasicDirector
implements SetListener<Table>,
InvocationService.ResultListener {
    protected ParlorContext _ctx;
    protected TableLobbyObject _tlobj;
    protected String _tableField;
    protected TableObserver _observer;
    protected Table _ourTable;
    protected ObserverList<SeatednessObserver> _seatedObservers = ObserverList.newFastUnsafe();

    public TableDirector(ParlorContext ctx, String tableField, TableObserver observer) {
        super((PresentsContext)ctx);
        this._ctx = ctx;
        this._tableField = tableField;
        this._observer = observer;
    }

    public void setTableObject(DObject tlobj) {
        this._tlobj = (TableLobbyObject)tlobj;
        tlobj.addListener((ChangeListener)this);
    }

    public void clearTableObject() {
        if (this._tlobj != null) {
            ((DObject)this._tlobj).removeListener((ChangeListener)this);
            this._tlobj = null;
        }
    }

    public void addSeatednessObserver(SeatednessObserver observer) {
        this._seatedObservers.add((Object)observer);
    }

    public void removeSeatednessObserver(SeatednessObserver observer) {
        this._seatedObservers.remove((Object)observer);
    }

    public boolean isSeated() {
        return this._ourTable != null;
    }

    public Table getSeatedTable() {
        return this._ourTable;
    }

    public void createTable(TableConfig tableConfig, GameConfig config) {
        if (this._ourTable != null) {
            Log.log.warning((Object)("Ignoring request to create table as we're already in a table [table=" + this._ourTable + "]."), new Object[0]);
            return;
        }
        if (this._tlobj == null) {
            Log.log.warning((Object)("Requested to create a table but we're not currently in a place [config=" + config + "]."), new Object[0]);
            return;
        }
        this._tlobj.getTableService().createTable(tableConfig, config, this);
    }

    public void joinTable(int tableId, int position) {
        if (this._ourTable != null) {
            Log.log.warning((Object)("Ignoring request to join table as we're already in a table [table=" + this._ourTable + "]."), new Object[0]);
            return;
        }
        if (this._tlobj == null) {
            Log.log.warning((Object)("Requested to join a table but we're not currently in a place [tableId=" + tableId + "]."), new Object[0]);
            return;
        }
        this._tlobj.getTableService().joinTable(tableId, position, (InvocationService.InvocationListener)this);
    }

    public void leaveTable(int tableId) {
        if (this._tlobj == null) {
            Log.log.warning((Object)("Requested to leave a table but we're not currently in a place [tableId=" + tableId + "]."), new Object[0]);
            return;
        }
        this._tlobj.getTableService().leaveTable(tableId, (InvocationService.InvocationListener)this);
    }

    public void startTableNow(int tableId) {
        if (this._tlobj == null) {
            Log.log.warning((Object)("Requested to start a table but we're not currently in a place [tableId=" + tableId + "]."), new Object[0]);
            return;
        }
        this._tlobj.getTableService().startTableNow(tableId, (InvocationService.InvocationListener)this);
    }

    public void bootPlayer(int tableId, Name target) {
        if (this._tlobj == null) {
            Log.log.warning((Object)("Requesting to boot a player from a table we're not currently in [tableId=" + tableId + ", target=" + target + "]."), new Object[0]);
            return;
        }
        this._tlobj.getTableService().bootPlayer(tableId, target, (InvocationService.InvocationListener)this);
    }

    public void clientDidLogoff(Client client) {
        super.clientDidLogoff(client);
        this._ourTable = null;
    }

    public void entryAdded(EntryAddedEvent<Table> event) {
        if (event.getName().equals(this._tableField)) {
            Table table = (Table)event.getEntry();
            this.checkSeatedness(table);
            this._observer.tableAdded(table);
        }
    }

    public void entryUpdated(EntryUpdatedEvent<Table> event) {
        if (event.getName().equals(this._tableField)) {
            Table table = (Table)event.getEntry();
            this.checkSeatedness(table);
            this._observer.tableUpdated(table);
        }
    }

    public void entryRemoved(EntryRemovedEvent<Table> event) {
        if (event.getName().equals(this._tableField)) {
            int tableId = (Integer)event.getKey();
            if (this._ourTable != null && tableId == this._ourTable.tableId) {
                this._ourTable = null;
                this.notifySeatedness(false);
            }
            this._observer.tableRemoved(tableId);
        }
    }

    public void requestProcessed(Object result) {
        int tableId = (Integer)result;
        if (this._tlobj == null) {
            Log.log.info((Object)("Table created, but no lobby. [tableId=" + tableId + "]."), new Object[0]);
            return;
        }
        Table table = (Table)this._tlobj.getTables().get((Comparable)Integer.valueOf(tableId));
        if (table == null) {
            Log.log.warning((Object)("Table created, but where is it? [tableId=" + tableId + "]"), new Object[0]);
            return;
        }
        if (table.gameOid != -1 && table.players.length == 0) {
            this._ctx.getParlorDirector().gameIsReady(table.gameOid);
        }
    }

    public void requestFailed(String reason) {
        Log.log.warning((Object)("Table action failed [reason=" + reason + "]."), new Object[0]);
        this._ctx.getChatDirector().displayFeedback("game.general", reason);
    }

    protected void checkSeatedness(Table table) {
        BodyObject self;
        Table oldTable = this._ourTable;
        if (table.equals(this._ourTable)) {
            this._ourTable = null;
        }
        if (table.containsPlayer((self = (BodyObject)this._ctx.getClient().getClientObject()).getVisibleName())) {
            this._ourTable = table;
        }
        if (Objects.equal((Object)oldTable, (Object)this._ourTable)) {
            return;
        }
        this.notifySeatedness(this._ourTable != null);
    }

    protected void notifySeatedness(final boolean isSeated) {
        this._seatedObservers.apply((ObserverList.ObserverOp)new ObserverList.ObserverOp<SeatednessObserver>(){

            public boolean apply(SeatednessObserver so) {
                so.seatednessDidChange(isSeated);
                return true;
            }
        });
    }
}

