/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.cron.server.persist;

import com.google.inject.Inject;
import com.samskivert.depot.CacheInvalidator;
import com.samskivert.depot.DepotRepository;
import com.samskivert.depot.DuplicateKeyException;
import com.samskivert.depot.Ops;
import com.samskivert.depot.PersistenceContext;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.clause.QueryClause;
import com.samskivert.depot.clause.Where;
import com.samskivert.depot.clause.WhereClause;
import com.samskivert.depot.expression.ColumnExp;
import com.samskivert.depot.expression.SQLExpression;
import com.threerings.cron.server.persist.CronRecord;
import java.util.Set;

public class CronRepository
extends DepotRepository {
    @Inject
    public CronRepository(PersistenceContext ctx) {
        super(ctx);
    }

    public boolean claimJob(String ident, int dayOfYear, int minuteOfDay) {
        if (this.load(CronRecord.getKey(ident), new QueryClause[0]) == null) {
            try {
                CronRecord record = new CronRecord();
                record.ident = ident;
                record.lastExecutedDay = dayOfYear;
                record.lastExecutedMinute = minuteOfDay;
                this.insert(record);
                return true;
            }
            catch (DuplicateKeyException dke) {
                return false;
            }
        }
        return this.updatePartial(CronRecord.class, (WhereClause)new Where((SQLExpression)Ops.and((SQLExpression[])new SQLExpression[]{CronRecord.IDENT.eq((Comparable)((Object)ident)), Ops.or((SQLExpression[])new SQLExpression[]{CronRecord.LAST_EXECUTED_DAY.notEq((Comparable)Integer.valueOf(dayOfYear)), CronRecord.LAST_EXECUTED_MINUTE.notEq((Comparable)Integer.valueOf(minuteOfDay))})})), (CacheInvalidator)CronRecord.getKey(ident), (ColumnExp)CronRecord.LAST_EXECUTED_DAY, dayOfYear, new Object[]{CronRecord.LAST_EXECUTED_MINUTE, minuteOfDay}) == 1;
    }

    protected void getManagedRecords(Set<Class<? extends PersistentRecord>> classes) {
        classes.add(CronRecord.class);
    }
}

