/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.cron.server;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.samskivert.util.Calendars;
import com.samskivert.util.Interval;
import com.samskivert.util.Lifecycle;
import com.samskivert.util.RandomUtil;
import com.samskivert.util.RunQueue;
import com.threerings.cron.Log;
import com.threerings.cron.server.persist.CronRepository;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;

public class CronLogic {
    protected JobTicker _ticker;
    protected ListMultimap<Integer, Job> _jobs = ArrayListMultimap.create();
    protected ConcurrentMap<String, Boolean> _running = new ConcurrentHashMap<String, Boolean>();
    @Inject
    protected CronRepository _cronRepo;
    protected static final int HOUR = 60;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleEvery(int hourlyPeriod, String ident, Runnable job) {
        int minOfHour = Math.abs(ident.hashCode()) % 60;
        int minOfDay = 0;
        ListMultimap<Integer, Job> listMultimap = this._jobs;
        synchronized (listMultimap) {
            while (minOfDay < 1440) {
                this._jobs.put((Object)(minOfDay + minOfHour), (Object)new Job(ident, job));
                minOfDay += hourlyPeriod * 60;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleAt(int hour, String ident, Runnable job) {
        int minOfHour = Math.abs(ident.toString().hashCode()) % 60;
        ListMultimap<Integer, Job> listMultimap = this._jobs;
        synchronized (listMultimap) {
            this._jobs.put((Object)(hour * 60 + minOfHour), (Object)new Job(ident, job));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unschedule(String ident) {
        ListMultimap<Integer, Job> listMultimap = this._jobs;
        synchronized (listMultimap) {
            Iterator iter = this._jobs.entries().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                if (!((Job)entry.getValue()).ident.equals(ident)) continue;
                iter.remove();
            }
        }
    }

    protected CronLogic(Lifecycle cycle, final ExecutorService execsvc) {
        this(cycle, new RunQueue(){

            public void postRunnable(Runnable r) {
                execsvc.execute(r);
            }

            public boolean isDispatchThread() {
                return false;
            }

            public boolean isRunning() {
                return !execsvc.isShutdown();
            }
        });
    }

    protected CronLogic(Lifecycle cycle, RunQueue runQueue) {
        this._ticker = new JobTicker(runQueue);
        cycle.addComponent((Lifecycle.BaseComponent)new Lifecycle.Component(){

            public void init() {
                Calendar cal = Calendar.getInstance();
                long curmils = (long)cal.get(13) * 1000L + (long)cal.get(14);
                CronLogic.this._ticker.schedule(60000L - curmils);
            }

            public void shutdown() {
                CronLogic.this._ticker.cancel();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeJobs(int minuteOfDay) {
        int dayOfYear = Calendars.now().get(6);
        ArrayList jobs = Lists.newArrayList();
        ListMultimap<Integer, Job> listMultimap = this._jobs;
        synchronized (listMultimap) {
            List sched = this._jobs.get((Object)minuteOfDay);
            if (sched != null) {
                jobs.addAll(sched);
            }
        }
        for (Job job : jobs) {
            this.executeJob(job, dayOfYear, minuteOfDay);
        }
    }

    protected void executeJob(final Job job, int dayOfYear, int minuteOfDay) {
        if (!this._cronRepo.claimJob(job.ident, dayOfYear, minuteOfDay)) {
            return;
        }
        if (this._running.putIfAbsent(job.ident, true) != null) {
            Log.log.info((Object)"Dropping job as it is still executing", new Object[]{"job", job});
            return;
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    try {
                        job.job.run();
                    }
                    catch (Throwable t) {
                        Log.log.warning((Object)"Job failed", new Object[]{"job", job, t});
                        CronLogic.this._running.remove(job.ident);
                    }
                }
                finally {
                    CronLogic.this._running.remove(job.ident);
                }
            }
        }.start();
    }

    protected static class Job {
        public final String ident;
        public final Runnable job;

        public Job(String ident, Runnable job) {
            this.ident = ident;
            this.job = job;
        }

        public String toString() {
            return String.valueOf(this.ident) + " " + this.job;
        }
    }

    protected class JobTicker
    extends Interval {
        protected Calendar _cal;
        protected int _prevMinute;

        public JobTicker(RunQueue runQueue) {
            super(runQueue);
            this._cal = Calendar.getInstance();
            this._prevMinute = this.getMinuteOfDay();
        }

        public void expired() {
            int curMinute = this.getMinuteOfDay();
            if (curMinute < this._prevMinute) {
                this.processMinutes(this._prevMinute + 1, 1439);
                this.processMinutes(0, curMinute);
            } else {
                this.processMinutes(this._prevMinute + 1, curMinute);
            }
            this._prevMinute = curMinute;
            this.schedule(61000L - (long)RandomUtil.getInt((int)2000));
        }

        protected int getMinuteOfDay() {
            this._cal.setTimeInMillis(System.currentTimeMillis());
            return this._cal.get(11) * 60 + this._cal.get(12);
        }

        protected void processMinutes(int fromMinute, int toMinute) {
            int mm = fromMinute;
            while (mm <= toMinute) {
                CronLogic.this.executeJobs(mm);
                ++mm;
            }
        }
    }
}

