/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.util.unsafe;

import com.samskivert.util.RunAnywhere;
import com.threerings.NenyaLog;

public class Unsafe {
    protected static boolean _gcEnabled = true;
    protected static boolean _loaded;
    protected static boolean _initialized;
    protected static Throwable _loadError;

    static {
        try {
            System.loadLibrary("unsafe");
            _loaded = true;
        }
        catch (Throwable t) {
            _loadError = t;
        }
    }

    public static void setGCEnabled(boolean enabled) {
        if (Unsafe.isLoaded()) {
            if (!_initialized && !(_initialized = Unsafe.init())) {
                return;
            }
            if (_initialized && enabled != _gcEnabled) {
                _gcEnabled = enabled;
                if (_gcEnabled) {
                    Unsafe.enableGC();
                } else {
                    Unsafe.disableGC();
                }
            }
        }
    }

    public static void sleep(int millis) {
        if (RunAnywhere.isLinux() && Unsafe.isLoaded()) {
            Unsafe.nativeSleep(millis);
        } else {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException ie) {
                NenyaLog.log.info((Object)("Thread.sleep(" + millis + ") interrupted."), new Object[0]);
            }
        }
    }

    public static boolean setuid(int uid) {
        if (!RunAnywhere.isWindows() && Unsafe.isLoaded()) {
            return Unsafe.nativeSetuid(uid);
        }
        return false;
    }

    public static boolean setgid(int gid) {
        if (!RunAnywhere.isWindows() && Unsafe.isLoaded()) {
            return Unsafe.nativeSetgid(gid);
        }
        return false;
    }

    public static boolean seteuid(int uid) {
        if (!RunAnywhere.isWindows() && Unsafe.isLoaded()) {
            return Unsafe.nativeSeteuid(uid);
        }
        return false;
    }

    public static boolean setegid(int gid) {
        if (!RunAnywhere.isWindows() && Unsafe.isLoaded()) {
            return Unsafe.nativeSetegid(gid);
        }
        return false;
    }

    protected static boolean isLoaded() {
        if (_loadError != null) {
            NenyaLog.log.warning((Object)"Unable to load 'unsafe' library", new Object[]{"e", _loadError});
            _loadError = null;
        }
        return _loaded;
    }

    protected static native void enableGC();

    protected static native void disableGC();

    protected static native void nativeSleep(int var0);

    protected static native boolean nativeSetuid(int var0);

    protected static native boolean nativeSetgid(int var0);

    protected static native boolean nativeSeteuid(int var0);

    protected static native boolean nativeSetegid(int var0);

    protected static native boolean init();
}

