/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.util;

import com.samskivert.util.IntListUtil;
import com.threerings.util.DirectionCodes;
import java.awt.Point;

public class DirectionUtil
implements DirectionCodes {
    protected static final String[] DIR_STRINGS = new String[]{"SOUTHWEST", "WEST", "NORTHWEST", "NORTH", "NORTHEAST", "EAST", "SOUTHEAST", "SOUTH", "WESTSOUTHWEST", "WESTNORTHWEST", "NORTHNORTHWEST", "NORTHNORTHEAST", "EASTNORTHEAST", "EASTSOUTHEAST", "SOUTHSOUTHEAST", "SOUTHSOUTHWEST"};
    protected static final String[] SHORT_DIR_STRINGS = new String[]{"SW", "W", "NW", "N", "NE", "E", "SE", "S", "WSW", "WNW", "NNW", "NNE", "ENE", "ESE", "SSE", "SSW"};
    protected static final int[] FINE_CW_ROTATE;
    protected static final int[] FINE_CCW_ROTATE;
    protected static final int[] ANGLE_MAP;

    static {
        int[] nArray = new int[16];
        nArray[0] = 8;
        nArray[1] = 9;
        nArray[2] = 10;
        nArray[3] = 11;
        nArray[4] = 12;
        nArray[5] = 13;
        nArray[6] = 14;
        nArray[7] = 15;
        nArray[8] = 1;
        nArray[9] = 2;
        nArray[10] = 3;
        nArray[11] = 4;
        nArray[12] = 5;
        nArray[13] = 6;
        nArray[14] = 7;
        FINE_CW_ROTATE = nArray;
        int[] nArray2 = new int[16];
        nArray2[0] = 15;
        nArray2[1] = 8;
        nArray2[2] = 9;
        nArray2[3] = 10;
        nArray2[4] = 11;
        nArray2[5] = 12;
        nArray2[6] = 13;
        nArray2[7] = 14;
        nArray2[9] = 1;
        nArray2[10] = 2;
        nArray2[11] = 3;
        nArray2[12] = 4;
        nArray2[13] = 5;
        nArray2[14] = 6;
        nArray2[15] = 7;
        FINE_CCW_ROTATE = nArray2;
        int[] nArray3 = new int[16];
        nArray3[0] = 1;
        nArray3[1] = 9;
        nArray3[2] = 2;
        nArray3[3] = 10;
        nArray3[4] = 3;
        nArray3[5] = 11;
        nArray3[6] = 4;
        nArray3[7] = 12;
        nArray3[8] = 5;
        nArray3[9] = 13;
        nArray3[10] = 6;
        nArray3[11] = 14;
        nArray3[12] = 7;
        nArray3[13] = 15;
        nArray3[15] = 8;
        ANGLE_MAP = nArray3;
    }

    public static String[] getDirectionNames() {
        return DIR_STRINGS;
    }

    public static String toString(int direction) {
        return direction >= 0 && direction < 16 ? DIR_STRINGS[direction] : "INVALID";
    }

    public static String toShortString(int direction) {
        return direction >= 0 && direction < 16 ? SHORT_DIR_STRINGS[direction] : "?";
    }

    public static int fromString(String dirstr) {
        int ii = 0;
        while (ii < 16) {
            if (DIR_STRINGS[ii].equals(dirstr)) {
                return ii;
            }
            ++ii;
        }
        return -1;
    }

    public static int fromShortString(String dirstr) {
        int ii = 0;
        while (ii < 16) {
            if (SHORT_DIR_STRINGS[ii].equals(dirstr)) {
                return ii;
            }
            ++ii;
        }
        return -1;
    }

    public static String toString(int[] directions) {
        StringBuilder buf = new StringBuilder("{");
        int ii = 0;
        while (ii < directions.length) {
            if (ii > 0) {
                buf.append(", ");
            }
            buf.append(DirectionUtil.toShortString(directions[ii]));
            ++ii;
        }
        return buf.append("}").toString();
    }

    public static int rotateCW(int direction, int ticks) {
        int ii = 0;
        while (ii < ticks) {
            direction = FINE_CW_ROTATE[direction];
            ++ii;
        }
        return direction;
    }

    public static int rotateCCW(int direction, int ticks) {
        int ii = 0;
        while (ii < ticks) {
            direction = FINE_CCW_ROTATE[direction];
            ++ii;
        }
        return direction;
    }

    public static int getOpposite(int direction) {
        return DirectionUtil.rotateCW(direction, FINE_CW_ROTATE.length / 2);
    }

    public static int getClosestCardinal(int direction) {
        return DirectionUtil.getClosest(direction, CARDINAL_DIRECTIONS, true);
    }

    public static int getClosest(int direction, int[] possible) {
        return DirectionUtil.getClosest(direction, possible, true);
    }

    public static int getClosest(int direction, int[] possible, boolean preferCW) {
        int first = direction;
        int second = direction;
        int ii = 0;
        while (ii <= 8) {
            if (IntListUtil.contains((int[])possible, (int)first)) {
                return first;
            }
            if (ii != 0 && IntListUtil.contains((int[])possible, (int)second)) {
                return second;
            }
            first = preferCW ? DirectionUtil.rotateCW(first, 1) : DirectionUtil.rotateCCW(first, 1);
            second = preferCW ? DirectionUtil.rotateCCW(second, 1) : DirectionUtil.rotateCW(second, 1);
            ++ii;
        }
        return -1;
    }

    public static int getDirection(Point a, Point b) {
        return DirectionUtil.getDirection(a.getX(), a.getY(), b.getX(), b.getY());
    }

    public static int getDirection(int ax, int ay, int bx, int by) {
        return DirectionUtil.getDirection(Math.atan2(by - ay, bx - ax));
    }

    public static int getDirection(double ax, double ay, double bx, double by) {
        return DirectionUtil.getDirection(Math.atan2(by - ay, bx - ax));
    }

    public static int getDirection(double theta) {
        theta = (theta + Math.PI) * 4.0 / Math.PI;
        return (int)(Math.round(theta) + 1L) % 8;
    }

    public static int getFineDirection(Point a, Point b) {
        return DirectionUtil.getFineDirection(a.x, a.y, b.x, b.y);
    }

    public static int getFineDirection(int ax, int ay, int bx, int by) {
        return DirectionUtil.getFineDirection(Math.atan2(by - ay, bx - ax));
    }

    public static int getFineDirection(double theta) {
        theta = (theta + Math.PI) * 8.0 / Math.PI;
        return ANGLE_MAP[(int)Math.round(theta) % 16];
    }

    public static void moveDirection(Point p, int direction, int dx, int dy) {
        if (direction >= 8) {
            throw new IllegalArgumentException("Fine coordinates not supported.");
        }
        switch (direction) {
            case 2: 
            case 3: 
            case 4: {
                p.y -= dy;
            }
        }
        switch (direction) {
            case 0: 
            case 6: 
            case 7: {
                p.y += dy;
            }
        }
        switch (direction) {
            case 0: 
            case 1: 
            case 2: {
                p.x -= dx;
            }
        }
        switch (direction) {
            case 4: 
            case 5: 
            case 6: {
                p.x += dx;
            }
        }
    }
}

