/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.sprite;

import com.samskivert.util.ObserverList;
import com.threerings.media.AbstractMedia;
import com.threerings.media.sprite.PathObserver;
import com.threerings.media.util.Path;
import com.threerings.media.util.Pathable;
import com.threerings.util.DirectionCodes;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;

public abstract class Sprite
extends AbstractMedia
implements DirectionCodes,
Pathable {
    protected int _ox = Integer.MIN_VALUE;
    protected int _oy = Integer.MIN_VALUE;
    protected int _oxoff;
    protected int _oyoff;
    protected int _orient = -1;
    protected Path _path;
    protected long _pathStamp;

    public Sprite() {
        this(0, 0);
    }

    public Sprite(int width, int height) {
        super(new Rectangle(0, 0, width, height));
    }

    @Override
    public int getX() {
        return this._ox;
    }

    @Override
    public int getY() {
        return this._oy;
    }

    public int getXOffset() {
        return this._oxoff;
    }

    public int getYOffset() {
        return this._oyoff;
    }

    public int getWidth() {
        return this._bounds.width;
    }

    public int getHeight() {
        return this._bounds.height;
    }

    @Override
    public void setOrientation(int orient) {
        this._orient = orient;
    }

    @Override
    public int getOrientation() {
        return this._orient;
    }

    @Override
    public void setLocation(int x, int y) {
        if (x == this._ox && y == this._oy) {
            return;
        }
        Rectangle obounds = new Rectangle(this._bounds);
        this._ox = x;
        this._oy = y;
        this.updateRenderOrigin();
        this.invalidateAfterChange(obounds);
    }

    @Override
    public void paint(Graphics2D gfx) {
        gfx.drawRect(this._bounds.x, this._bounds.y, this._bounds.width - 1, this._bounds.height - 1);
    }

    public void paintPath(Graphics2D gfx) {
        if (this._path != null) {
            this._path.paint(gfx);
        }
    }

    public boolean contains(int x, int y) {
        return this._bounds.contains(x, y);
    }

    public boolean hitTest(int x, int y) {
        return this._bounds.contains(x, y);
    }

    public boolean inside(Shape shape) {
        return shape.contains(this._ox, this._oy);
    }

    public boolean intersects(Shape shape) {
        return shape.intersects(this._bounds);
    }

    public boolean isMoving() {
        return this._path != null;
    }

    public void move(Path path) {
        this.cancelMove();
        this._path = path;
        this._pathStamp = 0L;
    }

    public void cancelMove() {
        if (this._path != null) {
            Path oldpath = this._path;
            this._path = null;
            oldpath.wasRemoved(this);
            if (this._observers != null) {
                this._observers.apply((ObserverList.ObserverOp)new CancelledOp(this, oldpath));
            }
        }
    }

    public Path getPath() {
        return this._path;
    }

    @Override
    public void pathBeginning() {
    }

    @Override
    public void pathCompleted(long timestamp) {
        Path oldpath = this._path;
        this._path = null;
        oldpath.wasRemoved(this);
        if (this._observers != null) {
            this._observers.apply((ObserverList.ObserverOp)new CompletedOp(this, oldpath, timestamp));
        }
    }

    @Override
    public void tick(long tickStamp) {
        this.tickPath(tickStamp);
    }

    protected boolean tickPath(long tickStamp) {
        if (this._path == null) {
            return false;
        }
        if (this._pathStamp == 0L) {
            this._pathStamp = tickStamp;
            this._path.init(this, this._pathStamp);
        }
        return this._path == null ? true : this._path.tick(this, tickStamp);
    }

    @Override
    public void fastForward(long timeDelta) {
        if (this._path != null) {
            this._path.fastForward(timeDelta);
        }
    }

    protected void updateRenderOrigin() {
        this._bounds.x = this._ox - this._oxoff;
        this._bounds.y = this._oy - this._oyoff;
    }

    public void addSpriteObserver(Object obs) {
        this.addObserver(obs);
    }

    public void removeSpriteObserver(Object obs) {
        this.removeObserver(obs);
    }

    @Override
    public void viewLocationDidChange(int dx, int dy) {
        if (this._renderOrder >= 65536) {
            this.setLocation(this._ox + dx, this._oy + dy);
        }
    }

    @Override
    protected void shutdown() {
        super.shutdown();
        this.cancelMove();
    }

    @Override
    protected void toString(StringBuilder buf) {
        super.toString(buf);
        buf.append(", ox=").append(this._ox);
        buf.append(", oy=").append(this._oy);
        buf.append(", oxoff=").append(this._oxoff);
        buf.append(", oyoff=").append(this._oyoff);
    }

    protected static class CancelledOp
    implements ObserverList.ObserverOp<Object> {
        protected Sprite _sprite;
        protected Path _path;

        public CancelledOp(Sprite sprite, Path path) {
            this._sprite = sprite;
            this._path = path;
        }

        public boolean apply(Object observer) {
            if (observer instanceof PathObserver) {
                ((PathObserver)observer).pathCancelled(this._sprite, this._path);
            }
            return true;
        }
    }

    protected static class CompletedOp
    implements ObserverList.ObserverOp<Object> {
        protected Sprite _sprite;
        protected Path _path;
        protected long _when;

        public CompletedOp(Sprite sprite, Path path, long when) {
            this._sprite = sprite;
            this._path = path;
            this._when = when;
        }

        public boolean apply(Object observer) {
            if (observer instanceof PathObserver) {
                ((PathObserver)observer).pathCompleted(this._sprite, this._path, this._when);
            }
            return true;
        }
    }
}

