/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.image;

import com.threerings.media.image.ImageUtil;
import com.threerings.media.image.Mirage;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public class TransformedMirage
implements Mirage {
    protected Mirage _base;
    protected Rectangle _bounds;
    protected AffineTransform _transform;

    public TransformedMirage(Mirage base, AffineTransform transform) {
        this(base, transform, true);
    }

    public TransformedMirage(Mirage base, AffineTransform transform, boolean reposition) {
        this._base = base;
        this._transform = (AffineTransform)transform.clone();
        this.computeTransformedBounds();
        if (reposition) {
            this._transform.preConcatenate(AffineTransform.getTranslateInstance(-this._bounds.x, -this._bounds.y));
        }
    }

    @Override
    public void paint(Graphics2D gfx, int x, int y) {
        AffineTransform otrans = gfx.getTransform();
        gfx.translate(x, y);
        gfx.transform(this._transform);
        this._base.paint(gfx, 0, 0);
        gfx.setTransform(otrans);
    }

    @Override
    public int getWidth() {
        return this._bounds.width;
    }

    @Override
    public int getHeight() {
        return this._bounds.height;
    }

    @Override
    public boolean hitTest(int x, int y) {
        Point p = new Point(x, y);
        try {
            this._transform.createInverse().transform(p, p);
            return this._base.hitTest(p.x, p.y);
        }
        catch (NoninvertibleTransformException nte) {
            return ImageUtil.hitTest(this.getSnapshot(), x, y);
        }
    }

    @Override
    public BufferedImage getSnapshot() {
        BufferedImage baseSnap = this._base.getSnapshot();
        BufferedImage img = new BufferedImage(this._bounds.width, this._bounds.height, baseSnap.getType());
        Graphics2D gfx = (Graphics2D)img.getGraphics();
        try {
            gfx.transform(this._transform);
            gfx.drawImage((Image)baseSnap, 0, 0, null);
        }
        finally {
            gfx.dispose();
        }
        return img;
    }

    @Override
    public long getEstimatedMemoryUsage() {
        return this._base.getEstimatedMemoryUsage();
    }

    protected void computeTransformedBounds() {
        int w = this._base.getWidth();
        int h = this._base.getHeight();
        Point2D[] points = new Point[]{new Point(0, 0), new Point(w, 0), new Point(0, h), new Point(w, h)};
        this._transform.transform(points, 0, points, 0, 4);
        int minY = Integer.MAX_VALUE;
        int minX = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxX = Integer.MIN_VALUE;
        int ii = 0;
        while (ii < 4) {
            minX = Math.min(minX, ((Point)points[ii]).x);
            maxX = Math.max(maxX, ((Point)points[ii]).x);
            minY = Math.min(minY, ((Point)points[ii]).y);
            maxY = Math.max(maxY, ((Point)points[ii]).y);
            ++ii;
        }
        this._bounds = new Rectangle(minX, minY, maxX - minX, maxY - minY);
    }
}

