/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.animation;

import com.samskivert.util.RandomUtil;
import com.threerings.media.animation.Animation;
import com.threerings.media.image.Mirage;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;

public class SparkAnimation
extends Animation {
    protected Mirage[] _images;
    protected int _icount;
    protected float _xacc;
    protected float _yacc;
    protected float[] _sxvel;
    protected float[] _syvel;
    protected int[] _ox;
    protected int[] _oy;
    protected int[] _xpos;
    protected int[] _ypos;
    protected long _start;
    protected boolean _fade;
    protected float _alpha;
    protected AlphaComposite _comp;
    protected long _delay;

    public SparkAnimation(Rectangle bounds, int x, int y, int xjog, int yjog, float minxvel, float minyvel, float maxxvel, float maxyvel, float xacc, float yacc, Mirage[] images, long delay, boolean fade) {
        super(bounds);
        this._xacc = xacc;
        this._yacc = yacc;
        this._images = images;
        this._delay = delay;
        this._fade = fade;
        this._icount = images.length;
        this._ox = new int[this._icount];
        this._oy = new int[this._icount];
        this._xpos = new int[this._icount];
        this._ypos = new int[this._icount];
        this._sxvel = new float[this._icount];
        this._syvel = new float[this._icount];
        int ii = 0;
        while (ii < this._icount) {
            this._ox[ii] = x + (xjog == 0 ? 0 : RandomUtil.getInt((int)xjog) * this.randomDirection());
            this._oy[ii] = y + (yjog == 0 ? 0 : RandomUtil.getInt((int)yjog) * this.randomDirection());
            this._sxvel[ii] = minxvel + RandomUtil.getFloat((float)1.0f) * (maxxvel - minxvel);
            this._syvel[ii] = minyvel + RandomUtil.getFloat((float)1.0f) * (maxyvel - minyvel);
            if (this._xacc > 0.0f) {
                this._sxvel[ii] = -this._sxvel[ii];
            } else if (this._xacc == 0.0f) {
                int n = ii;
                this._sxvel[n] = this._sxvel[n] * (float)this.randomDirection();
            }
            if (this._yacc > 0.0f) {
                this._syvel[ii] = -this._syvel[ii];
            } else if (this._yacc == 0.0f) {
                int n = ii;
                this._syvel[n] = this._syvel[n] * (float)this.randomDirection();
            }
            ++ii;
        }
        if (this._fade) {
            this._alpha = 1.0f;
            this._comp = AlphaComposite.getInstance(3, this._alpha);
        }
    }

    protected int randomDirection() {
        return RandomUtil.getBoolean() ? -1 : 1;
    }

    @Override
    protected void willStart(long stamp) {
        super.willStart(stamp);
        this._start = stamp;
    }

    @Override
    public void fastForward(long timeDelta) {
        this._start += timeDelta;
    }

    @Override
    public void tick(long timestamp) {
        long msecs = Math.max(timestamp - this._start, 0L);
        long msecsSq = msecs * msecs;
        if (this._fade) {
            float pctdone = (float)msecs / (float)this._delay;
            this._alpha = Math.max(0.1f, Math.min(1.0f, 1.0f - pctdone));
            this._comp = AlphaComposite.getInstance(3, this._alpha);
        }
        boolean allOutside = true;
        int ii = 0;
        while (ii < this._icount) {
            int xtrav = (int)(this._sxvel[ii] * (float)msecs + 0.5f * this._xacc * (float)msecsSq);
            int ytrav = (int)(this._syvel[ii] * (float)msecs + 0.5f * this._yacc * (float)msecsSq);
            this._xpos[ii] = this._ox[ii] + xtrav;
            this._ypos[ii] = this._oy[ii] + ytrav;
            if (allOutside && this._bounds.intersects(this._xpos[ii], this._ypos[ii], this._images[ii].getWidth(), this._images[ii].getHeight())) {
                allOutside = false;
            }
            ++ii;
        }
        this._finished = allOutside || msecs >= this._delay;
        this.invalidate();
    }

    @Override
    public void paint(Graphics2D gfx) {
        Shape oclip = gfx.getClip();
        gfx.clip(this._bounds);
        Composite ocomp = gfx.getComposite();
        if (this._fade) {
            gfx.setComposite(this._comp);
        }
        int ii = 0;
        while (ii < this._icount) {
            this._images[ii].paint(gfx, this._xpos[ii], this._ypos[ii]);
            ++ii;
        }
        gfx.setComposite(ocomp);
        gfx.setClip(oclip);
    }

    @Override
    protected void toString(StringBuilder buf) {
        super.toString(buf);
        buf.append(", ox=").append(this._ox);
        buf.append(", oy=").append(this._oy);
        buf.append(", alpha=").append(this._alpha);
    }
}

