/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.cast;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.samskivert.swing.RuntimeAdjust;
import com.samskivert.util.LRUHashMap;
import com.samskivert.util.StringUtil;
import com.samskivert.util.Throttle;
import com.samskivert.util.Tuple;
import com.threerings.cast.ActionCache;
import com.threerings.cast.ActionFrames;
import com.threerings.cast.ActionSequence;
import com.threerings.cast.CastPrefs;
import com.threerings.cast.CharacterComponent;
import com.threerings.cast.CharacterDescriptor;
import com.threerings.cast.CharacterSprite;
import com.threerings.cast.ComponentClass;
import com.threerings.cast.ComponentRepository;
import com.threerings.cast.CompositedActionFrames;
import com.threerings.cast.CompositedMaskedImage;
import com.threerings.cast.CompositedMultiFrameImage;
import com.threerings.cast.CompositedShadowImage;
import com.threerings.cast.Log;
import com.threerings.cast.NoSuchComponentException;
import com.threerings.media.image.Colorization;
import com.threerings.media.image.ImageManager;
import com.threerings.util.DirectionCodes;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CharacterManager
implements DirectionCodes {
    protected ImageManager _imgr;
    protected ComponentRepository _crepo;
    protected Map<String, ActionSequence> _actions = Maps.newHashMap();
    protected Map<Tuple<CharacterDescriptor, String>, ActionFrames> _actionFrames = Maps.newHashMap();
    protected LRUHashMap<CompositedActionFrames.CompositedFramesKey, CompositedMultiFrameImage> _frameCache;
    protected Class<? extends CharacterSprite> _charClass = CharacterSprite.class;
    protected ActionCache _acache;
    protected Throttle _cacheStatThrottle = new Throttle(1, 30000L);
    protected static RuntimeAdjust.IntAdjust _cacheSize = new RuntimeAdjust.IntAdjust("Size (in kb of memory used) of the character manager LRU action cache [requires restart]", "narya.cast.action_cache_size", CastPrefs.config, 32768);
    protected static int _runCacheSize = _cacheSize.getValue();

    public static void setCacheSize(int cacheKilobytes) {
        _runCacheSize = cacheKilobytes;
    }

    public CharacterManager(ImageManager imgr, ComponentRepository crepo) {
        this._imgr = imgr;
        this._crepo = crepo;
        Iterator<ActionSequence> iter = crepo.enumerateActionSequences();
        while (iter.hasNext()) {
            ActionSequence action = iter.next();
            this._actions.put(action.name, action);
        }
        Log.log.debug((Object)("Creating action cache [size=" + _runCacheSize + "k]."), new Object[0]);
        this._frameCache = new LRUHashMap(_runCacheSize * 1024, (LRUHashMap.ItemSizer)new LRUHashMap.ItemSizer<CompositedMultiFrameImage>(){

            public int computeSize(CompositedMultiFrameImage value) {
                return (int)value.getEstimatedMemoryUsage();
            }
        });
        this._frameCache.setTracking(true);
    }

    public ComponentRepository getComponentRepository() {
        return this._crepo;
    }

    public void setCharacterClass(Class<? extends CharacterSprite> charClass) {
        this._charClass = charClass;
    }

    public void setActionCache(ActionCache cache) {
        this._acache = cache;
    }

    public CharacterSprite getCharacter(CharacterDescriptor desc) {
        return this.getCharacter(desc, this._charClass);
    }

    public <T extends CharacterSprite> T getCharacter(CharacterDescriptor desc, Class<T> charClass) {
        try {
            CharacterSprite sprite = (CharacterSprite)charClass.newInstance();
            sprite.init(desc, this);
            return (T)sprite;
        }
        catch (Exception e) {
            Log.log.warning((Object)"Failed to instantiate character sprite.", new Object[]{e});
            return null;
        }
    }

    public ActionFrames getActionFrames(CharacterDescriptor descrip, String action) throws NoSuchComponentException {
        Tuple key = new Tuple((Object)descrip, (Object)action);
        ActionFrames frames = this._actionFrames.get(key);
        if (frames == null) {
            frames = this.createCompositeFrames(descrip, action);
            this._actionFrames.put((Tuple<CharacterDescriptor, String>)key, frames);
        }
        if (!this._cacheStatThrottle.throttleOp()) {
            long size = this.getEstimatedCacheMemoryUsage();
            int[] eff = this._frameCache.getTrackedEffectiveness();
            Log.log.debug((Object)("CharacterManager LRU [mem=" + size / 1024L + "k" + ", size=" + this._frameCache.size() + ", hits=" + eff[0] + ", misses=" + eff[1] + "]."), new Object[0]);
        }
        return frames;
    }

    public void resolveActionSequence(CharacterDescriptor desc, String action) {
        try {
            if (this.getActionFrames(desc, action) == null) {
                Log.log.warning((Object)("Failed to resolve action sequence [desc=" + desc + ", action=" + action + "]."), new Object[0]);
            }
        }
        catch (NoSuchComponentException nsce) {
            Log.log.warning((Object)("Failed to resolve action sequence [nsce=" + nsce + "]."), new Object[0]);
        }
    }

    public ActionSequence getActionSequence(String action) {
        return this._actions.get(action);
    }

    protected long getEstimatedCacheMemoryUsage() {
        long size = 0L;
        Iterator iter = this._frameCache.values().iterator();
        while (iter.hasNext()) {
            size += ((CompositedMultiFrameImage)iter.next()).getEstimatedMemoryUsage();
        }
        return size;
    }

    /*
     * WARNING - void declaration
     */
    protected ActionFrames createCompositeFrames(CharacterDescriptor descrip, String action) throws NoSuchComponentException {
        void var10_11;
        int[] cids = descrip.getComponentIds();
        int ccount = cids.length;
        Colorization[][] zations = descrip.getColorizations();
        Point[] xlations = descrip.getTranslations();
        Log.log.debug((Object)("Compositing action [action=" + action + ", descrip=" + descrip + "]."), new Object[0]);
        HashMap shadows = null;
        HashMap ccomps = Maps.newHashMap();
        ArrayList sources = Lists.newArrayListWithCapacity((int)ccount);
        boolean bl = false;
        while (var10_11 < ccount) {
            CompositedActionFrames.ComponentFrames cframes = new CompositedActionFrames.ComponentFrames();
            sources.add(cframes);
            CharacterComponent ccomp = cframes.ccomp = this._crepo.getComponent(cids[var10_11]);
            ActionFrames source = ccomp.getFrames(action, null);
            if (source == null) {
                String errmsg = "Cannot composite action frames; no such action for component [action=" + action + ", desc=" + descrip + ", comp=" + ccomp + "]";
                throw new RuntimeException(errmsg);
            }
            source = zations == null || zations[var10_11] == null ? source : source.cloneColorized(zations[var10_11]);
            Point xlation = xlations == null ? null : xlations[var10_11];
            cframes.frames = xlation == null ? source : source.cloneTranslated(xlation.x, xlation.y);
            TranslatedComponent tcomp = new TranslatedComponent(ccomp, xlation);
            ArrayList tcomps = (ArrayList)ccomps.get(ccomp.componentClass.name);
            if (tcomps == null) {
                tcomps = Lists.newArrayList();
                ccomps.put(ccomp.componentClass.name, tcomps);
            }
            tcomps.add(tcomp);
            if (ccomp.componentClass.isShadowed()) {
                ArrayList shadlist;
                if (shadows == null) {
                    shadows = Maps.newHashMap();
                }
                if ((shadlist = (ArrayList)shadows.get(ccomp.componentClass.shadow)) == null) {
                    shadlist = Lists.newArrayList();
                    shadows.put(ccomp.componentClass.shadow, shadlist);
                }
                shadlist.add(tcomp);
            }
            ++var10_11;
        }
        if (shadows != null) {
            for (Map.Entry entry : shadows.entrySet()) {
                CompositedActionFrames.ComponentFrames scf = this.compositeShadow(action, (String)entry.getKey(), (ArrayList)entry.getValue());
                if (scf == null) continue;
                sources.add(scf);
            }
        }
        for (CompositedActionFrames.ComponentFrames componentFrames : sources) {
            ArrayList mcomps = (ArrayList)ccomps.get(componentFrames.ccomp.componentClass.mask);
            if (mcomps == null) continue;
            componentFrames.frames = this.compositeMask(action, componentFrames.ccomp, componentFrames.frames, mcomps);
        }
        CompositedActionFrames.ComponentFrames[] componentFramesArray = sources.toArray(new CompositedActionFrames.ComponentFrames[sources.size()]);
        return new CompositedActionFrames(this._imgr, (Map<CompositedActionFrames.CompositedFramesKey, CompositedMultiFrameImage>)this._frameCache, action, componentFramesArray);
    }

    protected CompositedActionFrames.ComponentFrames compositeShadow(String action, String sclass, ArrayList<TranslatedComponent> scomps) {
        final ComponentClass cclass = this._crepo.getComponentClass(sclass);
        if (cclass == null) {
            Log.log.warning((Object)("Components reference non-existent shadow layer class [sclass=" + sclass + ", scomps=" + StringUtil.toString(scomps) + "]."), new Object[0]);
            return null;
        }
        CompositedActionFrames.ComponentFrames cframes = new CompositedActionFrames.ComponentFrames();
        cframes.ccomp = new CharacterComponent(-1, "shadow", cclass, null);
        ArrayList sources = Lists.newArrayList();
        for (TranslatedComponent scomp : scomps) {
            CompositedActionFrames.ComponentFrames source = new CompositedActionFrames.ComponentFrames();
            source.ccomp = scomp.ccomp;
            source.frames = scomp.getFrames(action, "shadow");
            if (source.frames == null) continue;
            sources.add(source);
        }
        if (sources.size() == 0) {
            return null;
        }
        CompositedActionFrames.ComponentFrames[] svec = sources.toArray(new CompositedActionFrames.ComponentFrames[sources.size()]);
        cframes.frames = new CompositedActionFrames(this._imgr, (Map)this._frameCache, action, svec){

            @Override
            protected CompositedMultiFrameImage createFrames(int orient) {
                return new CompositedShadowImage(this._imgr, this._sources, this._action, orient, cclass.shadowAlpha);
            }
        };
        return cframes;
    }

    protected ActionFrames compositeMask(String action, CharacterComponent ccomp, ActionFrames cframes, ArrayList<TranslatedComponent> mcomps) {
        ArrayList sources = Lists.newArrayList();
        sources.add(new CompositedActionFrames.ComponentFrames(ccomp, cframes));
        for (TranslatedComponent mcomp : mcomps) {
            ActionFrames mframes = mcomp.getFrames(action, "crop");
            if (mframes == null) continue;
            sources.add(new CompositedActionFrames.ComponentFrames(mcomp.ccomp, mframes));
        }
        if (sources.size() == 1) {
            return cframes;
        }
        CompositedActionFrames.ComponentFrames[] mvec = sources.toArray(new CompositedActionFrames.ComponentFrames[sources.size()]);
        return new CompositedActionFrames(this._imgr, (Map)this._frameCache, action, mvec){

            @Override
            protected CompositedMultiFrameImage createFrames(int orient) {
                return new CompositedMaskedImage(this._imgr, this._sources, this._action, orient);
            }
        };
    }

    protected static class TranslatedComponent {
        public CharacterComponent ccomp;
        public Point xlation;

        public TranslatedComponent(CharacterComponent ccomp, Point xlation) {
            this.ccomp = ccomp;
            this.xlation = xlation;
        }

        public ActionFrames getFrames(String action, String type) {
            ActionFrames frames = this.ccomp.getFrames(action, type);
            return frames == null || this.xlation == null ? frames : frames.cloneTranslated(this.xlation.x, this.xlation.y);
        }
    }
}

