/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.resource;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.samskivert.io.StreamUtil;
import com.samskivert.net.PathUtil;
import com.samskivert.util.ObserverList;
import com.samskivert.util.ResultListener;
import com.samskivert.util.WeakObserverList;
import com.threerings.resource.FastImageIO;
import com.threerings.resource.FileResourceBundle;
import com.threerings.resource.Handler;
import com.threerings.resource.Log;
import com.threerings.resource.NetworkResourceBundle;
import com.threerings.resource.ResourceBundle;
import java.awt.EventQueue;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class ResourceManager {
    protected ClassLoader _loader;
    protected File _rdir;
    protected String _rootPath;
    protected String _networkRootPath;
    protected boolean _unpack;
    protected ResourceBundle[] _default = new ResourceBundle[0];
    protected HashMap<String, ResourceBundle[]> _sets = Maps.newHashMap();
    protected LocaleHandler _localeHandler;
    protected HashMap<String, ObservedResource> _observed = Maps.newHashMap();
    protected static ResourceModifiedOp _resourceModifiedOp = new ResourceModifiedOp();
    protected static final String RESOURCE_SET_PREFIX = "resource.set.";
    protected static final String RESOURCE_SET_TYPE_PREFIX = "resource.set_type.";
    protected static final String DEFAULT_RESOURCE_SET = "default";
    protected static final String FILE_SET_TYPE = "file";
    protected static final String NETWORK_SET_TYPE = "network";

    public ResourceManager(String resourceRoot) {
        this(resourceRoot, ResourceManager.class.getClassLoader());
    }

    public ResourceManager(String resourceRoot, ClassLoader loader) {
        this(resourceRoot, null, loader);
    }

    public ResourceManager(String resourceRoot, String networkResourceRoot) {
        this(resourceRoot, networkResourceRoot, ResourceManager.class.getClassLoader());
    }

    public ResourceManager(String fileResourceRoot, String networkResourceRoot, ClassLoader loader) {
        this._rootPath = fileResourceRoot;
        this._networkRootPath = networkResourceRoot;
        this._loader = loader;
        try {
            this._unpack = !Boolean.getBoolean("no_unpack_resources");
        }
        catch (SecurityException se) {
            // empty catch block
        }
        this.initResourceDir(null);
    }

    public void activateResourceProtocol() {
        try {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Handler.registerHandler(ResourceManager.this);
                    return null;
                }
            });
        }
        catch (SecurityException se) {
            Log.log.info((Object)"Running in sandbox. Unable to bind rsrc:// handler.", new Object[0]);
        }
    }

    public void setLocalePrefix(final String prefix) {
        this.setLocaleHandler(new LocaleHandler(){

            @Override
            public String getLocalePath(String path) {
                return PathUtil.appendPath((String)prefix, (String)path);
            }
        });
    }

    public void setLocaleHandler(LocaleHandler localeHandler) {
        this._localeHandler = localeHandler;
    }

    public void setUnpackResources(boolean unpackResources) {
        this._unpack = unpackResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initBundles(String resourceDir, String configPath, InitObserver initObs) throws IOException {
        if (resourceDir != null) {
            this.initResourceDir(resourceDir);
        }
        Properties config = this.loadConfig(configPath);
        ArrayList dlist = Lists.newArrayList();
        Enumeration<?> names = config.propertyNames();
        while (names.hasMoreElements()) {
            String key = (String)names.nextElement();
            if (!key.startsWith(RESOURCE_SET_PREFIX)) continue;
            String setName = key.substring(RESOURCE_SET_PREFIX.length());
            String resourceSetType = config.getProperty(RESOURCE_SET_TYPE_PREFIX + setName, FILE_SET_TYPE);
            this.resolveResourceSet(setName, config.getProperty(key), resourceSetType, dlist);
        }
        final boolean[] shouldWait = new boolean[]{false};
        if (initObs == null) {
            shouldWait[0] = true;
            initObs = new InitObserver(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void progress(int percent, long remaining) {
                    if (percent >= 100) {
                        3 var4_3 = this;
                        synchronized (var4_3) {
                            shouldWait[0] = false;
                            this.notify();
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void initializationFailed(Exception e) {
                    3 var2_2 = this;
                    synchronized (var2_2) {
                        shouldWait[0] = false;
                        this.notify();
                    }
                }
            };
        }
        Unpacker unpack = new Unpacker(dlist, initObs);
        unpack.start();
        if (shouldWait[0]) {
            InitObserver initObserver = initObs;
            synchronized (initObserver) {
                if (shouldWait[0]) {
                    try {
                        initObs.wait();
                    }
                    catch (InterruptedException ie) {
                        Log.log.warning((Object)"Interrupted while waiting for bundles to unpack.", new Object[0]);
                    }
                }
            }
        }
    }

    public void initResourceDir(String resourceDir) {
        if (resourceDir == null) {
            try {
                resourceDir = System.getProperty("resource_dir");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (resourceDir == null) {
            return;
        }
        if (!resourceDir.endsWith(File.separator)) {
            resourceDir = resourceDir + File.separator;
        }
        this._rdir = new File(resourceDir);
    }

    public File getResourceFile(String path) {
        File file;
        String localePath;
        if (this._rdir == null) {
            return null;
        }
        if ('/' != File.separatorChar) {
            path = path.replace('/', File.separatorChar);
        }
        if ((localePath = this.getLocalePath(path)) != null && (file = new File(this._rdir, localePath)).exists()) {
            return file;
        }
        return new File(this._rdir, path);
    }

    public String getResourcePath(File file) {
        if (this._rdir == null) {
            return null;
        }
        try {
            String child;
            String parent = this._rdir.getCanonicalPath();
            if (!parent.endsWith(File.separator)) {
                parent = parent + File.separator;
            }
            if (!(child = file.getCanonicalPath()).startsWith(parent)) {
                return null;
            }
            String path = child.substring(parent.length());
            return File.separatorChar == '/' ? path : path.replace(File.separatorChar, '/');
        }
        catch (IOException e) {
            Log.log.warning((Object)"Failed to determine resource path", new Object[]{FILE_SET_TYPE, file, e});
            return null;
        }
    }

    public boolean checkBundle(String path) {
        File bfile = this.getResourceFile(path);
        return bfile == null ? false : new FileResourceBundle(bfile, true, this._unpack).isUnpacked();
    }

    public void resolveBundle(String path, final ResultListener<FileResourceBundle> listener) {
        File bfile = this.getResourceFile(path);
        if (bfile == null) {
            String errmsg = "ResourceManager not configured with resource directory.";
            listener.requestFailed((Exception)new IOException(errmsg));
            return;
        }
        final FileResourceBundle bundle = new FileResourceBundle(bfile, true, this._unpack);
        if (bundle.isUnpacked()) {
            if (bundle.sourceIsReady()) {
                listener.requestCompleted((Object)bundle);
            } else {
                String errmsg = "Bundle initialization failed.";
                listener.requestFailed((Exception)new IOException(errmsg));
            }
            return;
        }
        ArrayList list = Lists.newArrayList();
        list.add(bundle);
        Unpacker unpack = new Unpacker(list, new InitObserver(){

            @Override
            public void progress(int percent, long remaining) {
                if (percent == 100) {
                    listener.requestCompleted((Object)bundle);
                }
            }

            @Override
            public void initializationFailed(Exception e) {
                listener.requestFailed(e);
            }
        });
        unpack.start();
    }

    public ClassLoader getClassLoader() {
        return this._loader;
    }

    public void setClassLoader(ClassLoader loader) {
        this._loader = loader;
    }

    public InputStream getResource(String path) throws IOException {
        InputStream in;
        String localePath = this.getLocalePath(path);
        for (ResourceBundle bundle : this._default) {
            if (localePath != null && (in = bundle.getResource(localePath)) != null) {
                return in;
            }
            in = bundle.getResource(path);
            if (in == null) continue;
            return in;
        }
        File file = this.getResourceFile(path);
        if (file != null && file.exists()) {
            return new FileInputStream(file);
        }
        if (localePath != null && (in = this.getInputStreamFromClasspath(PathUtil.appendPath((String)this._rootPath, (String)localePath))) != null) {
            return in;
        }
        in = this.getInputStreamFromClasspath(PathUtil.appendPath((String)this._rootPath, (String)path));
        if (in != null) {
            return in;
        }
        throw new FileNotFoundException("Unable to locate resource [path=" + path + "]");
    }

    public BufferedImage getImageResource(String path) throws IOException {
        InputStream in;
        String localePath = this.getLocalePath(path);
        for (ResourceBundle bundle : this._default) {
            BufferedImage image;
            if (localePath != null && (image = bundle.getImageResource(localePath, false)) != null) {
                return image;
            }
            image = bundle.getImageResource(path, false);
            if (image == null) continue;
            return image;
        }
        File file = this.getResourceFile(path);
        if (file != null && file.exists()) {
            return ResourceManager.loadImage(file, path.endsWith(".raw"));
        }
        if (localePath != null && (in = this.getInputStreamFromClasspath(PathUtil.appendPath((String)this._rootPath, (String)localePath))) != null) {
            return ResourceManager.loadImage(in);
        }
        in = this.getInputStreamFromClasspath(PathUtil.appendPath((String)this._rootPath, (String)path));
        if (in != null) {
            return ResourceManager.loadImage(in);
        }
        throw new FileNotFoundException("Unable to locate image resource [path=" + path + "]");
    }

    public InputStream getResource(String rset, String path) throws IOException {
        ResourceBundle[] bundles = this.getResourceSet(rset);
        if (bundles == null) {
            throw new FileNotFoundException("Unable to locate resource [set=" + rset + ", path=" + path + "]");
        }
        String localePath = this.getLocalePath(path);
        for (ResourceBundle bundle : bundles) {
            InputStream in;
            if (localePath != null && (in = bundle.getResource(localePath)) != null) {
                return in;
            }
            in = bundle.getResource(path);
            if (in == null) continue;
            return in;
        }
        throw new FileNotFoundException("Unable to locate resource [set=" + rset + ", path=" + path + "]");
    }

    public BufferedImage getImageResource(String rset, String path) throws IOException {
        ResourceBundle[] bundles = this.getResourceSet(rset);
        if (bundles == null) {
            throw new FileNotFoundException("Unable to locate image resource [set=" + rset + ", path=" + path + "]");
        }
        String localePath = this.getLocalePath(path);
        for (ResourceBundle bundle : bundles) {
            BufferedImage image;
            if (localePath != null && (image = bundle.getImageResource(localePath, false)) != null) {
                return image;
            }
            image = bundle.getImageResource(path, false);
            if (image == null) continue;
            return image;
        }
        throw new FileNotFoundException("Unable to locate image resource [set=" + rset + ", path=" + path + "]");
    }

    public ResourceBundle[] getResourceSet(String name) {
        return this._sets.get(name);
    }

    public void addModificationObserver(String path, ModificationObserver obs) {
        ObservedResource resource = this._observed.get(path);
        if (resource == null) {
            File file = this.getResourceFile(path);
            if (file == null) {
                return;
            }
            resource = new ObservedResource(file);
            this._observed.put(path, resource);
        }
        resource.observers.add((Object)obs);
    }

    public void removeModificationObserver(String path, ModificationObserver obs) {
        ObservedResource resource = this._observed.get(path);
        if (resource != null) {
            resource.observers.remove((Object)obs);
        }
    }

    public void checkForModifications() {
        Iterator<Map.Entry<String, ObservedResource>> it = this._observed.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, ObservedResource> entry = it.next();
            ObservedResource resource = entry.getValue();
            if (!resource.checkForModification(entry.getKey())) continue;
            it.remove();
        }
    }

    protected Properties loadConfig(String configPath) throws IOException {
        Properties config = new Properties();
        try {
            config.load(new FileInputStream(new File(this._rdir, configPath)));
        }
        catch (Exception e) {
            String errmsg = "Unable to load resource manager config [rdir=" + this._rdir + ", cpath=" + configPath + "]";
            Log.log.warning((Object)(errmsg + "."), new Object[]{e});
            throw new IOException(errmsg);
        }
        return config;
    }

    public HashSet<String> getResourceList() {
        return null;
    }

    protected void resolveResourceSet(String setName, String definition, String setType, List<ResourceBundle> dlist) {
        ArrayList set = Lists.newArrayList();
        StringTokenizer tok = new StringTokenizer(definition, ":");
        while (tok.hasMoreTokens()) {
            set.add(this.createResourceBundle(setType, tok.nextToken().trim(), dlist));
        }
        ResourceBundle[] setvec = set.toArray(new ResourceBundle[set.size()]);
        this._sets.put(setName, setvec);
        if (DEFAULT_RESOURCE_SET.equals(setName)) {
            this._default = setvec;
        }
    }

    protected ResourceBundle createResourceBundle(String setType, String path, List<ResourceBundle> dlist) {
        if (setType.equals(FILE_SET_TYPE)) {
            FileResourceBundle bundle = this.createFileResourceBundle(this.getResourceFile(path), true, this._unpack);
            if (!bundle.isUnpacked() || !bundle.sourceIsReady()) {
                dlist.add(bundle);
            }
            return bundle;
        }
        if (setType.equals(NETWORK_SET_TYPE)) {
            return this.createNetworkResourceBundle(this._networkRootPath, path, this.getResourceList());
        }
        throw new IllegalArgumentException("Unknown set type: " + setType);
    }

    protected FileResourceBundle createFileResourceBundle(File source, boolean delay, boolean unpack) {
        return new FileResourceBundle(source, delay, unpack);
    }

    protected ResourceBundle createNetworkResourceBundle(String root, String path, Set<String> rsrcList) {
        return new NetworkResourceBundle(root, path, rsrcList);
    }

    protected InputStream getInputStreamFromClasspath(final String fullyQualifiedPath) {
        return AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                return ResourceManager.this._loader.getResourceAsStream(fullyQualifiedPath);
            }
        });
    }

    protected String getLocalePath(String path) {
        return this._localeHandler == null ? null : this._localeHandler.getLocalePath(path);
    }

    protected static BufferedImage loadImage(File file, boolean useFastIO) throws IOException {
        if (file == null) {
            return null;
        }
        if (useFastIO) {
            return FastImageIO.read(file);
        }
        return ImageIO.read(file);
    }

    public static BufferedImage loadImage(InputStream iis, boolean useFastIO) throws IOException {
        if (iis == null) {
            return null;
        }
        if (useFastIO) {
            return FastImageIO.read(iis);
        }
        return ImageIO.read(iis);
    }

    protected static BufferedImage loadImage(InputStream iis) throws IOException {
        BufferedImage image;
        block4: {
            if (iis instanceof ImageInputStream) {
                image = ImageIO.read(iis);
            } else {
                MemoryCacheImageInputStream mciis = new MemoryCacheImageInputStream(iis);
                image = ImageIO.read(mciis);
                try {
                    mciis.close();
                }
                catch (IOException ioe) {
                    if ("closed".equals(ioe.getMessage())) break block4;
                    Log.log.warning((Object)("Failure closing image input '" + iis + "'."), new Object[]{ioe});
                }
            }
        }
        StreamUtil.close((InputStream)iis);
        return image;
    }

    protected static int getNumericJavaVersion(String verstr) {
        Matcher m = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)(_\\d+)?.*").matcher(verstr);
        if (!m.matches()) {
            Log.log.warning((Object)("Unable to parse VM version, hoping for the best [version=" + verstr + "]"), new Object[0]);
            return 0;
        }
        int one = Integer.parseInt(m.group(1));
        int major = Integer.parseInt(m.group(2));
        int minor = Integer.parseInt(m.group(3));
        int patch = m.group(4) == null ? 0 : Integer.parseInt(m.group(4).substring(1));
        return patch + 100 * (minor + 100 * (major + 100 * one));
    }

    protected static class ResourceModifiedOp
    implements ObserverList.ObserverOp<ModificationObserver> {
        protected String _path;
        protected long _lastModified;

        protected ResourceModifiedOp() {
        }

        public void init(String path, long lastModified) {
            this._path = path;
            this._lastModified = lastModified;
        }

        public boolean apply(ModificationObserver obs) {
            obs.resourceModified(this._path, this._lastModified);
            return true;
        }
    }

    protected static class ObservedResource {
        public WeakObserverList<ModificationObserver> observers = WeakObserverList.newFastUnsafe();
        protected File _file;
        protected long _lastModified;

        public ObservedResource(File file) {
            this._file = file;
            this._lastModified = file.lastModified();
        }

        public boolean checkForModification(String path) {
            long newLastModified = this._file.lastModified();
            if (newLastModified > this._lastModified) {
                this._lastModified = newLastModified;
                _resourceModifiedOp.init(path, this._lastModified);
                this.observers.apply((ObserverList.ObserverOp)_resourceModifiedOp);
            } else {
                this.observers.prune();
            }
            return this.observers.isEmpty();
        }
    }

    protected static class Unpacker
    extends Thread {
        protected List<ResourceBundle> _bundles;
        protected InitObserver _obs;
        protected long _startTime;

        public Unpacker(List<ResourceBundle> bundles, InitObserver obs) {
            this._bundles = bundles;
            this._obs = obs;
            this._startTime = System.currentTimeMillis();
        }

        @Override
        public void run() {
            block9: {
                try {
                    if (this._obs != null) {
                        this._obs.progress(0, -1L);
                    }
                    int count = 0;
                    for (ResourceBundle bundle : this._bundles) {
                        if (bundle instanceof FileResourceBundle && !((FileResourceBundle)bundle).sourceIsReady()) {
                            Log.log.warning((Object)("Bundle failed to initialize " + bundle + "."), new Object[0]);
                        }
                        if (this._obs != null) {
                            int pct = count * 100 / this._bundles.size();
                            long remaining = 0L;
                            if (pct > 0) {
                                remaining = Math.round((double)(100 - pct) * ((double)(System.currentTimeMillis() - this._startTime) / 1000.0) / (double)pct);
                            }
                            if (pct < 100) {
                                this._obs.progress(pct, remaining);
                            }
                        }
                        ++count;
                    }
                    if (this._obs != null) {
                        this._obs.progress(100, 0L);
                    }
                }
                catch (Exception e) {
                    if (this._obs == null) break block9;
                    this._obs.initializationFailed(e);
                }
            }
        }
    }

    public static interface LocaleHandler {
        public String getLocalePath(String var1);
    }

    public static interface ModificationObserver {
        public void resourceModified(String var1, long var2);
    }

    public static class AWTInitObserver
    implements InitObserver {
        protected InitObserver _obs;

        public AWTInitObserver(InitObserver obs) {
            this._obs = obs;
        }

        @Override
        public void progress(final int percent, final long remaining) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AWTInitObserver.this._obs.progress(percent, remaining);
                }
            });
        }

        @Override
        public void initializationFailed(final Exception e) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AWTInitObserver.this._obs.initializationFailed(e);
                }
            });
        }
    }

    public static interface InitObserver {
        public void progress(int var1, long var2);

        public void initializationFailed(Exception var1);
    }
}

