/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.resource;

import com.samskivert.util.Logger;
import com.threerings.resource.KnownAvailabilityResourceBundle;
import com.threerings.resource.Log;
import com.threerings.resource.ResourceManager;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlException;
import java.util.Set;

public class NetworkResourceBundle
extends KnownAvailabilityResourceBundle {
    protected String _ident;
    protected URL _bundleURL;

    public NetworkResourceBundle(String root, String path, Set<String> rsrcList) {
        super(rsrcList);
        if (!root.endsWith("/")) {
            root = root + "/";
        }
        try {
            this._bundleURL = new URL(root + path);
        }
        catch (MalformedURLException mue) {
            Log.log.warning((Object)("Created malformed URL for resource. [root=" + root + ", path=" + path), new Object[0]);
        }
        this._ident = path;
    }

    @Override
    public String getIdent() {
        return this._ident;
    }

    @Override
    public InputStream getResource(String path) throws IOException {
        if (!this.isPossiblyAvailable(this._ident + path)) {
            return null;
        }
        URL resourceUrl = new URL(this._bundleURL, path);
        return NetworkResourceBundle.getResource(resourceUrl);
    }

    protected static InputStream getResource(URL resourceUrl) {
        URLConnection ucon;
        try {
            ucon = resourceUrl.openConnection();
        }
        catch (IOException ioe) {
            Log.log.warning((Object)("Unable to open connection [url=" + resourceUrl + ", ex=" + ioe + "]"), new Object[0]);
            return null;
        }
        try {
            ucon.connect();
            return ucon.getInputStream();
        }
        catch (IOException ioe) {
            Log.log.warning((Object)("Unable to open input stream [url=" + resourceUrl + ", ex=" + ioe + "]"), new Object[0]);
            return null;
        }
        catch (AccessControlException ace) {
            Log.log.warning((Object)("Unable to connect due to access permissions [url=" + resourceUrl + "]"), new Object[0]);
            throw ace;
        }
    }

    @Override
    public BufferedImage getImageResource(String path, boolean useFastIO) throws IOException {
        InputStream in = this.getResource(path);
        if (in == null) {
            return null;
        }
        return ResourceManager.loadImage(in, false);
    }

    public String toString() {
        return Logger.format((Object)this.getClass().getSimpleName(), (Object[])new Object[]{"url", this._bundleURL, "ident", this._ident, "knownResources", this._rsrcs != null});
    }
}

