/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.tile;

import com.threerings.media.image.Colorization;
import com.threerings.media.image.Mirage;
import com.threerings.media.tile.TileSet;
import java.awt.Graphics2D;
import java.util.Arrays;

public class Tile {
    public Key key;
    protected Mirage _mirage;
    protected static long _totalTileMemory = 0L;

    public void setImage(Mirage image) {
        if (this._mirage != null) {
            _totalTileMemory -= this._mirage.getEstimatedMemoryUsage();
        }
        this._mirage = image;
        if (this._mirage != null) {
            _totalTileMemory += this._mirage.getEstimatedMemoryUsage();
        }
    }

    public int getWidth() {
        return this._mirage.getWidth();
    }

    public int getHeight() {
        return this._mirage.getHeight();
    }

    public long getEstimatedMemoryUsage() {
        return this._mirage.getEstimatedMemoryUsage();
    }

    public void paint(Graphics2D gfx, int x, int y) {
        this._mirage.paint(gfx, x, y);
    }

    public boolean hitTest(int x, int y) {
        return this._mirage.hitTest(x, y);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[");
        this.toString(buf);
        return buf.append("]").toString();
    }

    protected void toString(StringBuilder buf) {
        buf.append(this._mirage.getWidth()).append("x");
        buf.append(this._mirage.getHeight());
    }

    protected void finalize() {
        if (this._mirage != null) {
            _totalTileMemory -= this._mirage.getEstimatedMemoryUsage();
        }
    }

    public static class Key {
        public TileSet tileSet;
        public int tileIndex;
        public Colorization[] zations;

        public Key(TileSet tileSet, int tileIndex, Colorization[] zations) {
            this.tileSet = tileSet;
            this.tileIndex = tileIndex;
            this.zations = zations;
        }

        public boolean equals(Object other) {
            if (other instanceof Key) {
                Key okey = (Key)other;
                return this.tileSet == okey.tileSet && this.tileIndex == okey.tileIndex && Arrays.equals(this.zations, okey.zations);
            }
            return false;
        }

        public int hashCode() {
            int code = this.tileSet == null ? this.tileIndex : this.tileSet.hashCode() ^ this.tileIndex;
            int zcount = this.zations == null ? 0 : this.zations.length;
            for (int ii = 0; ii < zcount; ++ii) {
                if (this.zations[ii] == null) continue;
                code ^= this.zations[ii].hashCode();
            }
            return code;
        }
    }
}

