/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.sprite;

import com.threerings.media.image.Mirage;
import com.threerings.media.sprite.Sprite;
import com.threerings.media.util.MultiFrameImage;
import com.threerings.media.util.SingleFrameImageImpl;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class ImageSprite
extends Sprite {
    public static final int DEFAULT_FRAME_RATE = 15;
    public static final int NO_ANIMATION = 0;
    public static final int MOVEMENT_CUED = 1;
    public static final int TIME_BASED = 2;
    public static final int TIME_SEQUENTIAL = 3;
    protected MultiFrameImage _frames;
    protected int _frameIdx;
    protected int _animMode;
    protected long _frameDelay;
    protected long _firstStamp = 0L;

    public ImageSprite() {
        this((MultiFrameImage)null);
    }

    public ImageSprite(MultiFrameImage frames) {
        this._frames = frames;
        this._frameIdx = 0;
        this._animMode = 0;
        this._frameDelay = 66L;
    }

    public ImageSprite(Mirage image) {
        this(new SingleFrameImageImpl(image));
    }

    @Override
    protected void init() {
        super.init();
        this.layout();
    }

    @Override
    public boolean hitTest(int x, int y) {
        if (!super.hitTest(x, y) || this._frames == null) {
            return false;
        }
        return this._frames.hitTest(this._frameIdx, x - this._bounds.x, y - this._bounds.y);
    }

    public void setAnimationMode(int mode) {
        this._animMode = mode;
    }

    public void setFrameRate(float fps) {
        this._frameDelay = (long)(1000.0f / fps);
    }

    public void setMirage(Mirage mirage) {
        this.setFrames(new SingleFrameImageImpl(mirage));
    }

    public void setFrames(MultiFrameImage frames) {
        if (frames == null) {
            return;
        }
        if (frames == this._frames) {
            return;
        }
        this._frames = frames;
        this._frameIdx = 0;
        this.layout();
    }

    public void layout() {
        if (this._frames != null) {
            this.setFrameIndex(this._frameIdx, true);
        }
    }

    protected void setFrameIndex(int frameIdx, boolean forceUpdate) {
        if ((frameIdx %= this._frames.getFrameCount()) == this._frameIdx && !forceUpdate) {
            return;
        }
        this._frameIdx = frameIdx;
        Rectangle dirty = new Rectangle(this._bounds);
        this.accomodateFrame(this._frameIdx, this._frames.getWidth(this._frameIdx), this._frames.getHeight(this._frameIdx));
        dirty.add(this._bounds);
        if (this._mgr != null) {
            this._mgr.getRegionManager().addDirtyRegion(dirty);
        }
    }

    protected void accomodateFrame(int frameIdx, int width, int height) {
        this._bounds.width = width;
        this._bounds.height = height;
    }

    @Override
    public void paint(Graphics2D gfx) {
        if (this._frames != null) {
            this._frames.paintFrame(gfx, this._frameIdx, this._bounds.x, this._bounds.y);
        } else {
            super.paint(gfx);
        }
    }

    @Override
    public void tick(long timestamp) {
        if (this._frames == null) {
            return;
        }
        int fcount = this._frames.getFrameCount();
        boolean moved = false;
        moved = this.tickPath(timestamp);
        int nfidx = this._frameIdx;
        switch (this._animMode) {
            case 0: {
                break;
            }
            case 2: {
                nfidx = (int)(timestamp / this._frameDelay % (long)fcount);
                break;
            }
            case 3: {
                if (this._firstStamp == 0L) {
                    this._firstStamp = timestamp;
                }
                nfidx = (int)((timestamp - this._firstStamp) / this._frameDelay % (long)fcount);
                break;
            }
            case 1: {
                if (!moved) break;
                nfidx = (this._frameIdx + 1) % fcount;
            }
        }
        this.setFrameIndex(nfidx, false);
    }

    @Override
    protected void toString(StringBuilder buf) {
        super.toString(buf);
        buf.append(", fidx=").append(this._frameIdx);
    }
}

