/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.util;

import com.samskivert.util.ResultListener;
import com.samskivert.util.RunAnywhere;
import com.samskivert.util.StringUtil;
import com.threerings.NenyaLog;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserUtil {
    public static void browseURL(URL url, ResultListener<Void> listener) {
        BrowserUtil.browseURL(url, listener, "firefox");
    }

    public static void browseURL(URL url, ResultListener<Void> listener, String genagent) {
        String osName;
        Object[] cmd = RunAnywhere.isWindows() ? ((osName = System.getProperty("os.name")).indexOf("9") != -1 || osName.indexOf("Me") != -1 ? new String[]{"command.com", "/c", "start", "\"" + url.toString() + "\""} : new String[]{"cmd.exe", "/c", "start", "\"\"", "\"" + url.toString() + "\""}) : (RunAnywhere.isMacOS() ? new String[]{"open", url.toString()} : new String[]{genagent, url.toString()});
        String logcmd = StringUtil.join((Object[])cmd, (String)" ");
        logcmd = logcmd.replaceAll("password=[^&]*", "password=XXX");
        NenyaLog.log.info((Object)("Browsing URL [cmd=" + logcmd + "]."), new Object[0]);
        try {
            Process process = Runtime.getRuntime().exec((String[])cmd);
            BrowserTracker tracker = new BrowserTracker(process, url, listener);
            tracker.start();
        }
        catch (Exception e) {
            NenyaLog.log.warning((Object)("Failed to launch browser [url=" + url + ", error=" + e + "]."), new Object[0]);
            listener.requestFailed(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class BrowserTracker
    extends Thread {
        protected Process _process;
        protected URL _url;
        protected ResultListener<Void> _listener;

        public BrowserTracker(Process process, URL url, ResultListener<Void> rl) {
            super("BrowserLaunchWaiter");
            this.setDaemon(true);
            this._process = process;
            this._url = url;
            this._listener = rl;
        }

        @Override
        public void run() {
            try {
                this._process.waitFor();
                int rv = this._process.exitValue();
                if (rv == 0) {
                    return;
                }
                String errmsg = "Launched browser failed [rv=" + rv + "].";
                NenyaLog.log.warning((Object)errmsg, new Object[0]);
                if (!RunAnywhere.isWindows()) {
                    this._listener.requestFailed(new Exception(errmsg));
                    return;
                }
                String[] cmd = new String[]{"C:\\Program Files\\Internet Explorer\\IEXPLORE.EXE", "\"" + this._url.toString() + "\""};
                Process process = Runtime.getRuntime().exec(cmd);
                process.waitFor();
                rv = process.exitValue();
                if (rv != 0) {
                    errmsg = "Failed to launch iexplore.exe [rv=" + rv + "].";
                    NenyaLog.log.warning((Object)errmsg, new Object[0]);
                    this._listener.requestFailed(new Exception(errmsg));
                }
            }
            catch (Exception e) {
                this._listener.requestFailed(e);
            }
        }
    }
}

