/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.resource;

import com.samskivert.io.StreamUtil;
import com.samskivert.util.FileUtil;
import com.samskivert.util.StringUtil;
import com.threerings.resource.Log;
import com.threerings.resource.ResourceBundle;
import com.threerings.resource.ResourceManager;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class FileResourceBundle
extends ResourceBundle {
    protected File _source;
    protected long _sourceLastMod = -1L;
    protected File _unpacked;
    protected File _cache;
    protected JarFile _jarSource;
    protected static File _tmpdir;

    public FileResourceBundle(File source) {
        this(source, false, false);
    }

    public FileResourceBundle(File source, boolean delay, boolean unpack) {
        this._source = source;
        if (unpack) {
            String root = FileResourceBundle.stripSuffix(source.getPath());
            this._unpacked = new File(String.valueOf(root) + ".stamp");
            this._cache = new File(root);
        }
        if (!delay) {
            this.sourceIsReady();
        }
    }

    public String getIdent() {
        return this._source.getPath();
    }

    public InputStream getResource(String path) throws IOException {
        File rfile = this.getResourceFile(path);
        return rfile == null ? null : new FileInputStream(rfile);
    }

    public BufferedImage getImageResource(String path, boolean useFastIO) throws IOException {
        return ResourceManager.loadImage(this.getResourceFile(path), useFastIO);
    }

    public File getSource() {
        return this._source;
    }

    public boolean isUnpacked() {
        return this._source.exists() && this._unpacked != null && this._unpacked.lastModified() == this._source.lastModified();
    }

    public boolean sourceIsReady() {
        this._sourceLastMod = this._source.lastModified();
        if (this._unpacked != null && this._unpacked.lastModified() != this._sourceLastMod) {
            try {
                this.resolveJarFile();
            }
            catch (IOException ioe) {
                Log.log.warning((Object)"Failure resolving jar file", new Object[]{"source", this._source, ioe});
                this.wipeBundle(true);
                return false;
            }
            Log.log.info((Object)("Unpacking into " + this._cache + "..."), new Object[0]);
            if (!this._cache.exists()) {
                if (!this._cache.mkdir()) {
                    Log.log.warning((Object)"Failed to create bundle cache directory", new Object[]{"dir", this._cache});
                    this.closeJar();
                    return false;
                }
            } else {
                FileUtil.recursiveClean((File)this._cache);
            }
            if (!FileUtil.unpackJar((JarFile)this._jarSource, (File)this._cache)) {
                this.wipeBundle(true);
                return false;
            }
            try {
                this._unpacked.createNewFile();
                if (!this._unpacked.setLastModified(this._sourceLastMod)) {
                    Log.log.warning((Object)"Failed to set last mod on stamp file", new Object[]{"file", this._unpacked});
                }
            }
            catch (IOException ioe) {
                Log.log.warning((Object)"Failure creating stamp file", new Object[]{"file", this._unpacked, ioe});
            }
        }
        return true;
    }

    public void wipeBundle(boolean deleteJar) {
        File vfile;
        if (this._cache != null) {
            FileUtil.recursiveClean((File)this._cache);
        }
        if (this._unpacked != null) {
            this._unpacked.delete();
        }
        if ((vfile = new File(FileUtil.resuffix((File)this._source, (String)".jar", (String)".jarv"))).exists() && !vfile.delete()) {
            Log.log.warning((Object)"Failed to delete vfile", new Object[]{"file", vfile});
        }
        if (deleteJar && this._source != null) {
            this.closeJar();
            if (!this._source.delete()) {
                Log.log.warning((Object)"Failed to delete source", new Object[]{"source", this._source, "exists", this._source.exists()});
            }
        }
    }

    public File getResourceFile(String path) throws IOException {
        if (this.resolveJarFile()) {
            return null;
        }
        if (this._cache != null) {
            File cfile = new File(this._cache, path);
            if (cfile.exists()) {
                return cfile;
            }
            return null;
        }
        String tpath = StringUtil.md5hex((String)(String.valueOf(this._source.getPath()) + "%" + path));
        File tfile = new File(FileResourceBundle.getCacheDir(), tpath);
        if (tfile.exists() && tfile.lastModified() > this._sourceLastMod) {
            return tfile;
        }
        JarEntry entry = this._jarSource.getJarEntry(path);
        if (entry == null) {
            return null;
        }
        BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(tfile));
        InputStream jin = this._jarSource.getInputStream(entry);
        StreamUtil.copy((InputStream)jin, (OutputStream)fout);
        jin.close();
        fout.close();
        return tfile;
    }

    public boolean containsResource(String path) {
        block3: {
            try {
                if (!this.resolveJarFile()) break block3;
                return false;
            }
            catch (IOException ioe) {
                return false;
            }
        }
        return this._jarSource.getJarEntry(path) != null;
    }

    public String toString() {
        try {
            this.resolveJarFile();
            return this._jarSource == null ? "[file=" + this._source + "]" : "[path=" + this._jarSource.getName() + "]";
        }
        catch (IOException ioe) {
            return "[file=" + this._source + ", ioe=" + ioe + "]";
        }
    }

    protected boolean resolveJarFile() throws IOException {
        if (this._sourceLastMod == -1L) {
            return true;
        }
        if (!this._source.exists()) {
            throw new IOException("Missing jar file for resource bundle: " + this._source + ".");
        }
        try {
            if (this._jarSource == null) {
                this._jarSource = new JarFile(this._source);
            }
            return false;
        }
        catch (IOException ioe) {
            String msg = "Failed to resolve resource bundle jar file '" + this._source + "'";
            Log.log.warning((Object)(String.valueOf(msg) + "."), new Object[]{ioe});
            throw (IOException)new IOException(msg).initCause(ioe);
        }
    }

    protected void closeJar() {
        try {
            if (this._jarSource != null) {
                this._jarSource.close();
            }
        }
        catch (Exception ioe) {
            Log.log.warning((Object)"Failed to close jar file", new Object[]{"path", this._source, "error", ioe});
        }
    }

    public static File getCacheDir() {
        if (_tmpdir == null) {
            String tmpdir = System.getProperty("java.io.tmpdir");
            if (tmpdir == null) {
                Log.log.info((Object)"No system defined temp directory. Faking it.", new Object[0]);
                tmpdir = System.getProperty("user.home");
            }
            FileResourceBundle.setCacheDir(new File(tmpdir));
        }
        return _tmpdir;
    }

    public static void setCacheDir(File tmpdir) {
        String rando = Long.toHexString((long)(Math.random() * 9.223372036854776E18));
        _tmpdir = new File(tmpdir, "narcache_" + rando);
        if (!_tmpdir.exists()) {
            if (_tmpdir.mkdirs()) {
                Log.log.debug((Object)("Created narya temp cache directory '" + _tmpdir + "'."), new Object[0]);
            } else {
                Log.log.warning((Object)("Failed to create temp cache directory '" + _tmpdir + "'."), new Object[0]);
            }
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                Log.log.info((Object)("Clearing narya temp cache '" + _tmpdir + "'."), new Object[0]);
                FileUtil.recursiveDelete((File)_tmpdir);
            }
        });
    }

    protected static String stripSuffix(String path) {
        if (path.endsWith(".jar")) {
            return path.substring(0, path.length() - 4);
        }
        return String.valueOf(path) + "-cache";
    }
}

