/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.miso.util;

import com.samskivert.swing.SmartPolygon;
import com.threerings.media.util.MathUtil;
import com.threerings.miso.util.MisoSceneMetrics;
import com.threerings.util.DirectionCodes;
import com.threerings.util.DirectionUtil;
import java.awt.Point;
import java.awt.Polygon;

public class MisoUtil
implements DirectionCodes {
    protected static final int FULL_TILE_FACTOR = 100;

    public static int getDirection(MisoSceneMetrics metrics, int ax, int ay, int bx, int by) {
        Point afpos = new Point();
        Point bfpos = new Point();
        MisoUtil.screenToFull(metrics, ax, ay, afpos);
        MisoUtil.screenToFull(metrics, bx, by, bfpos);
        int tax = MisoUtil.fullToTile(afpos.x);
        int tay = MisoUtil.fullToTile(afpos.y);
        int tbx = MisoUtil.fullToTile(bfpos.x);
        int tby = MisoUtil.fullToTile(bfpos.y);
        int dir = MisoUtil.getIsoDirection(tax, tay, tbx, tby);
        if (dir != -1) {
            return dir;
        }
        int fax = afpos.x - tax * 100;
        int fay = afpos.y - tay * 100;
        int fbx = bfpos.x - tbx * 100;
        int fby = bfpos.y - tby * 100;
        dir = MisoUtil.getIsoDirection(fax, fay, fbx, fby);
        return dir == -1 ? 0 : dir;
    }

    public static int getIsoDirection(int ax, int ay, int bx, int by) {
        if (bx == ax) {
            if (by == ay) {
                return -1;
            }
            return by < ay ? 5 : 1;
        }
        float slope = (float)(ay - by) / (float)Math.abs(ax - bx);
        if (slope > 2.0f) {
            return 5;
        }
        if (slope > 0.5f) {
            return bx < ax ? 4 : 6;
        }
        if (slope > -0.5f) {
            return bx < ax ? 3 : 7;
        }
        if (slope > -2.0f) {
            return bx < ax ? 2 : 0;
        }
        return 1;
    }

    public static int getProjectedIsoDirection(int ax, int ay, int bx, int by) {
        return MisoUtil.toIsoDirection(DirectionUtil.getDirection(ax, ay, bx, by));
    }

    public static int toIsoDirection(int dir) {
        if (dir != -1) {
            dir = DirectionUtil.rotateCW(dir, 2);
        }
        return dir;
    }

    public static int fullToTile(int val) {
        return MathUtil.floorDiv(val, 100);
    }

    public static int fullToFine(int val) {
        return val - MisoUtil.fullToTile(val) * 100;
    }

    public static Point screenToTile(MisoSceneMetrics metrics, int sx, int sy, Point tpos) {
        int zx = (int)Math.floor((float)sx / (float)metrics.tilewid);
        int zy = (int)Math.floor((float)sy / (float)metrics.tilehei);
        int ox = zx * metrics.tilewid;
        int oy = zy * metrics.tilehei;
        tpos.x = zy + zx;
        tpos.y = zy - zx;
        int dx = sx - ox;
        int dy = sy - oy;
        if (Math.round(metrics.slopeY * (float)dx + (float)metrics.tilehei) <= dy) {
            ++tpos.x;
        }
        if (Math.round(metrics.slopeX * (float)dx) > dy) {
            --tpos.y;
        }
        return tpos;
    }

    public static Point tileToScreen(MisoSceneMetrics metrics, int x, int y, Point spos) {
        spos.x = (x - y - 1) * metrics.tilehwid;
        spos.y = (x + y) * metrics.tilehhei;
        return spos;
    }

    public static void fineToPixel(MisoSceneMetrics metrics, int x, int y, Point ppos) {
        ppos.x = metrics.tilehwid + (x - y) * metrics.finehwid;
        ppos.y = (x + y) * metrics.finehhei;
    }

    public static void pixelToFine(MisoSceneMetrics metrics, int x, int y, Point fpos) {
        float bY = (float)y - metrics.fineSlopeY * (float)x;
        int crossx = (int)((bY - metrics.fineBX) / (metrics.fineSlopeX - metrics.fineSlopeY));
        int crossy = (int)(metrics.fineSlopeY * (float)crossx + bY);
        float xdist = MathUtil.distance(metrics.tilehwid, 0, crossx, crossy);
        fpos.x = (int)(xdist / metrics.finelen);
        float ydist = MathUtil.distance(x, y, crossx, crossy);
        fpos.y = (int)(ydist / metrics.finelen);
    }

    public static Point screenToFull(MisoSceneMetrics metrics, int sx, int sy, Point fpos) {
        Point tpos = new Point();
        MisoUtil.screenToTile(metrics, sx, sy, tpos);
        Point spos = MisoUtil.tileToScreen(metrics, tpos.x, tpos.y, new Point());
        MisoUtil.pixelToFine(metrics, sx - spos.x, sy - spos.y, fpos);
        fpos.x += tpos.x * 100;
        fpos.y += tpos.y * 100;
        return fpos;
    }

    public static Point fullToScreen(MisoSceneMetrics metrics, int x, int y, Point spos) {
        int tx = MisoUtil.fullToTile(x);
        int ty = MisoUtil.fullToTile(y);
        Point tspos = MisoUtil.tileToScreen(metrics, tx, ty, new Point());
        Point ppos = new Point();
        int fx = x - tx * 100;
        int fy = y - ty * 100;
        MisoUtil.fineToPixel(metrics, fx, fy, ppos);
        spos.x = tspos.x + ppos.x;
        spos.y = tspos.y + ppos.y;
        return spos;
    }

    public static int fineToFull(MisoSceneMetrics metrics, int fine) {
        return MisoUtil.toFull(fine / metrics.finegran, fine % metrics.finegran);
    }

    public static int tileToFull(int tile) {
        return MisoUtil.toFull(tile, 0);
    }

    public static int toFull(int tile, int fine) {
        return tile * 100 + fine;
    }

    public static Polygon getTilePolygon(MisoSceneMetrics metrics, int x, int y) {
        return MisoUtil.getFootprintPolygon(metrics, x, y, 1, 1);
    }

    public static Polygon getMultiTilePolygon(MisoSceneMetrics metrics, Point sp1, Point sp2) {
        int x = Math.min(sp1.x, sp2.x);
        int y = Math.min(sp1.y, sp2.y);
        int width = Math.abs(sp1.x - sp2.x) + 1;
        int height = Math.abs(sp1.y - sp2.y) + 1;
        return MisoUtil.getFootprintPolygon(metrics, x, y, width, height);
    }

    public static Polygon getFootprintPolygon(MisoSceneMetrics metrics, int x, int y, int width, int height) {
        SmartPolygon footprint = new SmartPolygon();
        Point tpos = MisoUtil.tileToScreen(metrics, x, y, new Point());
        int rx = tpos.x + metrics.tilehwid;
        int ry = tpos.y;
        footprint.addPoint(rx, ry);
        footprint.addPoint(rx += width * metrics.tilehwid, ry += width * metrics.tilehhei);
        footprint.addPoint(rx -= height * metrics.tilehwid, ry += height * metrics.tilehhei);
        footprint.addPoint(rx -= width * metrics.tilehwid, ry -= width * metrics.tilehhei);
        footprint.addPoint(rx += height * metrics.tilehwid, ry -= height * metrics.tilehhei);
        return footprint;
    }

    public static Point tilePlusFineToFull(MisoSceneMetrics metrics, int tileX, int tileY, int fineX, int fineY, Point full) {
        int fy;
        int dtx = fineX / metrics.finegran;
        int dty = fineY / metrics.finegran;
        int fx = fineX - dtx * metrics.finegran;
        if (fx < 0) {
            --dtx;
            fx += metrics.finegran;
        }
        if ((fy = fineY - dty * metrics.finegran) < 0) {
            --dty;
            fy += metrics.finegran;
        }
        full.x = MisoUtil.toFull(tileX + dtx, fx);
        full.y = MisoUtil.toFull(tileY + dty, fy);
        return full;
    }

    public static final int coordsToKey(int x, int y) {
        return y << 16 & 0xFFFF0000 | x & 0xFFFF;
    }

    public static final int xCoordFromKey(int key) {
        return key & 0xFFFF;
    }

    public static final int yCoordFromKey(int key) {
        return key >> 16 & 0xFFFF;
    }
}

