/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.miso.data;

import com.samskivert.util.ArrayUtil;
import com.samskivert.util.IntListUtil;
import com.samskivert.util.ListUtil;
import com.threerings.media.util.MathUtil;
import com.threerings.miso.data.MisoSceneModel;
import com.threerings.miso.data.ObjectInfo;
import com.threerings.miso.util.ObjectSet;
import java.awt.Rectangle;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMisoSceneModel
extends MisoSceneModel {
    public short width;
    public short height;
    public int vwidth;
    public int vheight;
    public int[] baseTileIds;
    public int[] objectTileIds;
    public short[] objectXs;
    public short[] objectYs;
    public ObjectInfo[] objectInfo;

    public SimpleMisoSceneModel() {
    }

    public SimpleMisoSceneModel(int width, int height, int vwidth, int vheight) {
        this.width = (short)MathUtil.bound(Short.MIN_VALUE, width, Short.MAX_VALUE);
        this.height = (short)MathUtil.bound(Short.MIN_VALUE, height, Short.MAX_VALUE);
        this.vwidth = vwidth;
        this.vheight = vheight;
        this.allocateBaseTileArray();
        this.objectTileIds = new int[0];
        this.objectXs = new short[0];
        this.objectYs = new short[0];
        this.objectInfo = new ObjectInfo[0];
    }

    @Override
    public int getBaseTileId(int col, int row) {
        int index = this.getIndex(col, row);
        return index == -1 ? 0 : this.baseTileIds[index];
    }

    @Override
    public boolean setBaseTile(int fqBaseTileId, int col, int row) {
        int index = this.getIndex(col, row);
        if (index == -1) {
            return false;
        }
        this.baseTileIds[index] = fqBaseTileId;
        return true;
    }

    @Override
    public void getObjects(Rectangle region, ObjectSet set) {
        ObjectInfo[] objectInfoArray = this.objectInfo;
        int n = this.objectInfo.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectInfo info = objectInfoArray[n2];
            if (region.contains(info.x, info.y)) {
                set.insert(info);
            }
            ++n2;
        }
        int ii = 0;
        while (ii < this.objectTileIds.length) {
            short x = this.objectXs[ii];
            short y = this.objectYs[ii];
            if (region.contains(x, y)) {
                set.insert(new ObjectInfo(this.objectTileIds[ii], x, y));
            }
            ++ii;
        }
    }

    @Override
    public boolean addObject(ObjectInfo info) {
        if (info.isInteresting()) {
            this.objectInfo = (ObjectInfo[])ArrayUtil.append((Object[])this.objectInfo, (Object)info);
        } else {
            this.objectTileIds = ArrayUtil.append((int[])this.objectTileIds, (int)info.tileId);
            this.objectXs = ArrayUtil.append((short[])this.objectXs, (short)((short)info.x));
            this.objectYs = ArrayUtil.append((short[])this.objectYs, (short)((short)info.y));
        }
        return true;
    }

    @Override
    public void updateObject(ObjectInfo info) {
        this.removeObject(info);
        this.addObject(info);
    }

    @Override
    public boolean removeObject(ObjectInfo info) {
        int oidx = ListUtil.indexOf((Object[])this.objectInfo, (Object)info);
        if (oidx != -1) {
            this.objectInfo = (ObjectInfo[])ArrayUtil.splice((Object[])this.objectInfo, (int)oidx, (int)1);
            return true;
        }
        oidx = IntListUtil.indexOf((int[])this.objectTileIds, (int)info.tileId);
        if (oidx != -1) {
            this.objectTileIds = ArrayUtil.splice((int[])this.objectTileIds, (int)oidx, (int)1);
            this.objectXs = ArrayUtil.splice((short[])this.objectXs, (int)oidx, (int)1);
            this.objectYs = ArrayUtil.splice((short[])this.objectYs, (int)oidx, (int)1);
            return true;
        }
        return false;
    }

    @Override
    public SimpleMisoSceneModel clone() {
        SimpleMisoSceneModel model = (SimpleMisoSceneModel)super.clone();
        model.baseTileIds = (int[])this.baseTileIds.clone();
        model.objectTileIds = (int[])this.objectTileIds.clone();
        model.objectXs = (short[])this.objectXs.clone();
        model.objectYs = (short[])this.objectYs.clone();
        model.objectInfo = new ObjectInfo[this.objectInfo.length];
        int ii = 0;
        while (ii < this.objectInfo.length) {
            model.objectInfo[ii] = this.objectInfo[ii].clone();
            ++ii;
        }
        return model;
    }

    protected int getIndex(int x, int y) {
        if ((x + y & 1) == (this.vwidth & 1)) {
            int col = this.vwidth + x - y >> 1;
            int row = x - col;
            if (col < 0 || col > this.vwidth || row < 0 || row >= this.vheight) {
                return -1;
            }
            return (this.vwidth + 1) * row + col;
        }
        int col = this.vwidth + x - y - 1 >> 1;
        int row = x - col;
        if (col < 0 || col >= this.vwidth || row < 0 || row > this.vheight) {
            return -1;
        }
        return row * this.vwidth + col + (this.vwidth + 1) * this.vheight;
    }

    protected void allocateBaseTileArray() {
        this.baseTileIds = new int[this.vwidth + this.vheight + (this.vwidth * this.vheight << 1)];
    }

    public static void populateObjects(SimpleMisoSceneModel model, List<ObjectInfo> ilist, List<ObjectInfo> ulist) {
        int ucount = ulist.size();
        model.objectTileIds = new int[ucount];
        model.objectXs = new short[ucount];
        model.objectYs = new short[ucount];
        int ii = 0;
        while (ii < ucount) {
            ObjectInfo info = ulist.get(ii);
            model.objectTileIds[ii] = info.tileId;
            model.objectXs[ii] = (short)info.x;
            model.objectYs[ii] = (short)info.y;
            ++ii;
        }
        int icount = ilist.size();
        model.objectInfo = new ObjectInfo[icount];
        ilist.toArray(model.objectInfo);
    }
}

