/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.miso.client;

import com.google.common.collect.Lists;
import com.samskivert.util.SortableArrayList;
import com.threerings.media.sprite.Sprite;
import com.threerings.media.tile.ObjectTile;
import com.threerings.miso.client.MultiTileSprite;
import com.threerings.miso.client.SceneObject;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirtyItemList {
    protected SortableArrayList<DirtyItem> _items = new SortableArrayList();
    protected SortableArrayList<DirtyItem> _xitems = new SortableArrayList();
    protected SortableArrayList<DirtyItem> _yitems = new SortableArrayList();
    protected SortableArrayList<DirtyItem> _ditems = new SortableArrayList();
    protected Comparator<DirtyItem> _rcomp = new RenderComparator();
    protected ArrayList<DirtyItem> _freelist = Lists.newArrayList();
    protected static final boolean DEBUG_COMPARE = false;
    protected static final boolean DEBUG_SORT = false;
    protected static final int X_AXIS = 0;
    protected static final int Y_AXIS = 1;
    protected static final Comparator<DirtyItem> ORIGIN_X_COMP = new OriginComparator(0);
    protected static final Comparator<DirtyItem> ORIGIN_Y_COMP = new OriginComparator(1);
    protected static final Comparator<DirtyItem> REAR_DEPTH_COMP = new Comparator<DirtyItem>(){

        @Override
        public int compare(DirtyItem o1, DirtyItem o2) {
            int priDiff;
            int depthDiff = o1.getRearDepth() - o2.getRearDepth();
            if (depthDiff != 0) {
                return depthDiff;
            }
            if (o1.obj instanceof SceneObject && o2.obj instanceof SceneObject && (priDiff = ((SceneObject)o1.obj).getPriority() - ((SceneObject)o2.obj).getPriority()) != 0) {
                return priDiff;
            }
            return depthDiff;
        }
    };

    public void appendDirtySprite(Sprite sprite, int tx, int ty) {
        DirtyItem item = this.getDirtyItem();
        item.init(sprite, tx, ty);
        this._items.add((Object)item);
    }

    public void appendDirtyObject(SceneObject scobj) {
        DirtyItem item = this.getDirtyItem();
        item.init(scobj, scobj.info.x, scobj.info.y);
        this._items.add((Object)item);
    }

    public DirtyItem get(int idx) {
        return (DirtyItem)this._items.get(idx);
    }

    public void sort() {
        int size = this.size();
        if (size > 1) {
            this._xitems.addAll(this._items);
            this._xitems.sort(ORIGIN_X_COMP);
            this._yitems.addAll(this._items);
            this._yitems.sort(ORIGIN_Y_COMP);
            this._ditems.addAll(this._items);
            this._ditems.sort(REAR_DEPTH_COMP);
            this._items.clear();
            int ii = 0;
            while (ii < size) {
                block4: {
                    DirtyItem item = (DirtyItem)this._ditems.get(ii);
                    int rr = this._items.size() - 1;
                    while (rr >= 0) {
                        DirtyItem pitem = (DirtyItem)this._items.get(rr);
                        if (this._rcomp.compare(item, pitem) > 0) {
                            this._items.add(rr + 1, (Object)item);
                            break block4;
                        }
                        --rr;
                    }
                    this._items.add(0, (Object)item);
                }
                ++ii;
            }
            this._xitems.clear();
            this._yitems.clear();
            this._ditems.clear();
        }
    }

    public void paintAndClear(Graphics2D gfx) {
        int icount = this._items.size();
        int ii = 0;
        while (ii < icount) {
            DirtyItem item = (DirtyItem)this._items.get(ii);
            item.paint(gfx);
            item.clear();
            this._freelist.add(item);
            ++ii;
        }
        this._items.clear();
    }

    public void clear() {
        int icount = this._items.size();
        while (icount > 0) {
            DirtyItem item = (DirtyItem)this._items.remove(0);
            item.clear();
            this._freelist.add(item);
            --icount;
        }
    }

    public int size() {
        return this._items.size();
    }

    protected DirtyItem getDirtyItem() {
        if (this._freelist.size() > 0) {
            return this._freelist.remove(0);
        }
        return new DirtyItem();
    }

    protected static String toString(DirtyItem a) {
        StringBuilder buf = new StringBuilder("[");
        DirtyItemList.toString(buf, a);
        return buf.append("]").toString();
    }

    protected static String toString(DirtyItem a, DirtyItem b) {
        StringBuilder buf = new StringBuilder("[");
        DirtyItemList.toString(buf, a);
        DirtyItemList.toString(buf, b);
        return buf.append("]").toString();
    }

    protected static String toString(SortableArrayList<DirtyItem> items) {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        int ii = 0;
        while (ii < items.size()) {
            DirtyItem item = (DirtyItem)items.get(ii);
            DirtyItemList.toString(buf, item);
            if (ii < items.size() - 1) {
                buf.append(", ");
            }
            ++ii;
        }
        return buf.append("]").toString();
    }

    protected static void toString(StringBuilder buf, DirtyItem item) {
        buf.append("(o:+").append(item.ox).append("+").append(item.oy);
        buf.append(" p:").append(item.getRenderPriority()).append(")");
    }

    public class DirtyItem {
        public Object obj;
        public int ox;
        public int oy;
        public int lx;
        public int ly;
        public int rx;
        public int ry;

        public void init(Object obj, int x, int y) {
            this.obj = obj;
            this.ox = x;
            this.oy = y;
            this.lx = this.rx = this.ox;
            this.ly = this.ry = this.oy;
            if (obj instanceof SceneObject) {
                ObjectTile tile = ((SceneObject)obj).tile;
                this.lx -= tile.getBaseWidth() - 1;
                this.ry -= tile.getBaseHeight() - 1;
            } else if (obj instanceof MultiTileSprite) {
                MultiTileSprite mts = (MultiTileSprite)obj;
                this.lx -= mts.getBaseWidth() - 1;
                this.ry -= mts.getBaseHeight() - 1;
            }
        }

        public void paint(Graphics2D gfx) {
            if (this.obj instanceof Sprite) {
                ((Sprite)this.obj).paint(gfx);
            } else {
                ((SceneObject)this.obj).paint(gfx);
            }
        }

        public int getRearDepth() {
            return this.ry + this.lx;
        }

        public int getRenderPriority() {
            if (this.obj instanceof SceneObject) {
                return ((SceneObject)this.obj).getPriority();
            }
            return 0;
        }

        public void clear() {
            this.obj = null;
        }

        public boolean equals(Object other) {
            if (!(other instanceof DirtyItem)) {
                return false;
            }
            DirtyItem b = (DirtyItem)other;
            return this.obj.equals(b.obj);
        }

        public int hashCode() {
            return this.obj.hashCode();
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("[obj=").append(this.obj);
            buf.append(", ox=").append(this.ox);
            buf.append(", oy=").append(this.oy);
            buf.append(", lx=").append(this.lx);
            buf.append(", ly=").append(this.ly);
            buf.append(", rx=").append(this.rx);
            buf.append(", ry=").append(this.ry);
            return buf.append("]").toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class OriginComparator
    implements Comparator<DirtyItem> {
        protected int _axis;

        public OriginComparator(int axis) {
            this._axis = axis;
        }

        @Override
        public int compare(DirtyItem da, DirtyItem db) {
            if (this._axis == 0) {
                if (da.ox != db.ox) {
                    return da.ox - db.ox;
                }
            } else if (da.oy != db.oy) {
                return da.oy - db.oy;
            }
            return da.getRenderPriority() - db.getRenderPriority();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RenderComparator
    implements Comparator<DirtyItem> {
        protected RenderComparator() {
        }

        @Override
        public int compare(DirtyItem da, DirtyItem db) {
            SceneObject sob;
            SceneObject soa;
            if (da.obj instanceof SceneObject && db.obj instanceof SceneObject && (soa = (SceneObject)da.obj).objectFootprintOverlaps(sob = (SceneObject)db.obj)) {
                int result = soa.getPriority() - sob.getPriority();
                return result;
            }
            int result = this.comparePartitioned(1, da, db);
            if (result != 0) {
                return result;
            }
            result = this.comparePartitioned(0, da, db);
            if (result != 0) {
                return result;
            }
            result = this.compareNonPartitioned(da, db);
            return result;
        }

        protected int comparePartitioned(int axis, DirtyItem da, DirtyItem db) {
            Comparator<DirtyItem> comp;
            SortableArrayList<DirtyItem> sitems;
            boolean swapped = false;
            switch (axis) {
                case 0: {
                    DirtyItem temp;
                    if (da.ox == db.ox) {
                        return 0;
                    }
                    if (da.ox > db.ox) {
                        temp = da;
                        da = db;
                        db = temp;
                        swapped = true;
                    }
                    sitems = DirtyItemList.this._xitems;
                    comp = ORIGIN_X_COMP;
                    break;
                }
                default: {
                    DirtyItem temp;
                    if (da.oy == db.oy) {
                        return 0;
                    }
                    if (da.oy > db.oy) {
                        temp = da;
                        da = db;
                        db = temp;
                        swapped = true;
                    }
                    sitems = DirtyItemList.this._yitems;
                    comp = ORIGIN_Y_COMP;
                }
            }
            int aidx = sitems.binarySearch((Object)da, comp);
            int bidx = sitems.binarySearch((Object)db, comp);
            int size = bidx - aidx - 1;
            int startidx = aidx + 1;
            int endidx = startidx + size;
            int pidx = startidx;
            while (pidx < endidx) {
                DirtyItem dp = (DirtyItem)sitems.get(pidx);
                if (!(dp.obj instanceof Sprite) && dp.obj != da.obj && dp.obj != db.obj) {
                    switch (axis) {
                        case 0: {
                            if (dp.ly < da.ry || dp.ry > db.ly || dp.lx < da.rx || dp.rx > db.lx) break;
                            return swapped ? 1 : -1;
                        }
                        default: {
                            if (dp.lx > db.ox || dp.rx < da.lx || dp.ry < da.oy || dp.oy > db.ry) break;
                            return swapped ? 1 : -1;
                        }
                    }
                }
                ++pidx;
            }
            return 0;
        }

        protected int compareNonPartitioned(DirtyItem da, DirtyItem db) {
            int bRender;
            int aRender;
            int rocomp;
            if (da.ox == db.ox && da.oy == db.oy) {
                if (da.equals(db)) {
                    return 0;
                }
                boolean aIsSprite = da.obj instanceof Sprite;
                boolean bIsSprite = db.obj instanceof Sprite;
                if (aIsSprite && bIsSprite) {
                    Sprite as = (Sprite)da.obj;
                    Sprite bs = (Sprite)db.obj;
                    int rocomp2 = as.getRenderOrder() - bs.getRenderOrder();
                    if (rocomp2 != 0) {
                        return rocomp2;
                    }
                    int ydiff = as.getY() - bs.getY();
                    if (ydiff != 0) {
                        return ydiff;
                    }
                    return as.hashCode() - bs.hashCode();
                }
                if (aIsSprite) {
                    return 1;
                }
                if (bIsSprite) {
                    return -1;
                }
            }
            if ((da.obj instanceof MultiTileSprite || db.obj instanceof MultiTileSprite) && da.lx <= db.rx && da.rx >= db.lx && da.ry <= db.ly && da.ly >= db.ry && (rocomp = (aRender = da.obj instanceof Sprite ? ((Sprite)da.obj).getRenderOrder() : 0) - (bRender = db.obj instanceof Sprite ? ((Sprite)db.obj).getRenderOrder() : 0)) != 0) {
                return rocomp;
            }
            if (db.lx <= da.ox && db.ry <= da.oy) {
                return 1;
            }
            if (db.rx >= da.lx && db.ly >= da.ry) {
                return -1;
            }
            return da.oy - db.oy;
        }
    }
}

