/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.tile;

import com.samskivert.util.ListUtil;
import com.samskivert.util.StringUtil;
import com.threerings.media.image.Colorization;
import com.threerings.media.tile.BaseSizableTileSet;
import com.threerings.media.tile.ObjectTile;
import com.threerings.media.tile.RecolorableTileSet;
import com.threerings.media.tile.SwissArmyTileSet;
import com.threerings.media.tile.Tile;
import com.threerings.media.tile.TileSet;

public class ObjectTileSet
extends SwissArmyTileSet
implements RecolorableTileSet,
BaseSizableTileSet {
    public static final String SPACE = "SPACE_";
    public static final String SURFACE = "SURFACE";
    public static final String ON_SURFACE = "ON_SURFACE";
    public static final String WALL = "WALL_";
    public static final String ON_WALL = "ON_WALL_";
    public static final String ATTACH = "ATTACH_";
    public static final String LOW = "_LOW";
    protected int[] _owidths;
    protected int[] _oheights;
    protected int[] _xorigins;
    protected int[] _yorigins;
    protected byte[] _priorities;
    protected String[] _zations;
    protected short[] _xspots;
    protected short[] _yspots;
    protected byte[] _sorients;
    protected String[][] _constraints;
    private static final long serialVersionUID = 2L;

    public void setObjectWidths(int[] objectWidths) {
        this._owidths = objectWidths;
    }

    public void setObjectHeights(int[] objectHeights) {
        this._oheights = objectHeights;
    }

    public void setXOrigins(int[] xorigins) {
        this._xorigins = xorigins;
    }

    public void setYOrigins(int[] yorigins) {
        this._yorigins = yorigins;
    }

    public void setPriorities(byte[] priorities) {
        this._priorities = priorities;
    }

    public void setColorizations(String[] zations) {
        this._zations = zations;
    }

    public void setXSpots(short[] xspots) {
        this._xspots = xspots;
    }

    public void setYSpots(short[] yspots) {
        this._yspots = yspots;
    }

    public void setSpotOrients(byte[] sorients) {
        this._sorients = sorients;
    }

    public void setConstraints(String[][] constraints) {
        this._constraints = constraints;
    }

    public int getXSpot(int tileIdx) {
        return this._xspots == null ? 0 : this._xspots[tileIdx];
    }

    public int getYSpot(int tileIdx) {
        return this._yspots == null ? 0 : this._yspots[tileIdx];
    }

    public int getSpotOrient(int tileIdx) {
        return this._sorients == null ? 0 : this._sorients[tileIdx];
    }

    public String[] getConstraints(int tileIdx) {
        return this._constraints == null ? null : this._constraints[tileIdx];
    }

    public boolean hasConstraint(int tileIdx, String constraint) {
        return this._constraints == null ? false : ListUtil.contains((Object[])this._constraints[tileIdx], (Object)constraint);
    }

    public String[] getColorizations() {
        return this._zations;
    }

    public int getBaseWidth(int tileIdx) {
        return this._owidths[tileIdx];
    }

    public int getBaseHeight(int tileIdx) {
        return this._oheights[tileIdx];
    }

    protected void toString(StringBuilder buf) {
        super.toString(buf);
        buf.append(", owidths=").append(StringUtil.toString((Object)this._owidths));
        buf.append(", oheights=").append(StringUtil.toString((Object)this._oheights));
        buf.append(", xorigins=").append(StringUtil.toString((Object)this._xorigins));
        buf.append(", yorigins=").append(StringUtil.toString((Object)this._yorigins));
        buf.append(", prios=").append(StringUtil.toString((Object)this._priorities));
        buf.append(", zations=").append(StringUtil.toString((Object)this._zations));
        buf.append(", xspots=").append(StringUtil.toString((Object)this._xspots));
        buf.append(", yspots=").append(StringUtil.toString((Object)this._yspots));
        buf.append(", sorients=").append(StringUtil.toString((Object)this._sorients));
        buf.append(", constraints=").append(StringUtil.toString((Object)this._constraints));
    }

    protected Colorization[] getColorizations(int tileIndex, TileSet.Colorizer rizer) {
        Colorization[] zations = null;
        if (rizer != null && this._zations != null) {
            zations = new Colorization[this._zations.length];
            int ii = 0;
            while (ii < this._zations.length) {
                zations[ii] = rizer.getColorization(ii, this._zations[ii]);
                ++ii;
            }
        }
        return zations;
    }

    protected Tile createTile() {
        return new ObjectTile();
    }

    protected void initTile(Tile tile, int tileIndex, Colorization[] zations) {
        super.initTile(tile, tileIndex, zations);
        ObjectTile otile = (ObjectTile)tile;
        if (this._owidths != null) {
            otile.setBase(this._owidths[tileIndex], this._oheights[tileIndex]);
        }
        if (this._xorigins != null) {
            otile.setOrigin(this._xorigins[tileIndex], this._yorigins[tileIndex]);
        }
        if (this._priorities != null) {
            otile.setPriority(this._priorities[tileIndex]);
        }
        if (this._xspots != null) {
            otile.setSpot(this._xspots[tileIndex], this._yspots[tileIndex], this._sorients[tileIndex]);
        }
        if (this._constraints != null) {
            otile.setConstraints(this._constraints[tileIndex]);
        }
    }
}

