/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.animation;

import com.samskivert.swing.Label;
import com.samskivert.swing.util.SwingUtil;
import com.threerings.media.animation.FadeAnimation;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;

public class FadeLabelAnimation
extends FadeAnimation {
    protected Label _label;
    protected boolean _antiAliased;

    public FadeLabelAnimation(Label label, int x, int y, float alpha, float step, float target) {
        super(new Rectangle(x, y, 0, 0), alpha, step, target);
        this._label = label;
    }

    public void setAntiAliased(boolean antiAliased) {
        this._antiAliased = antiAliased;
    }

    protected void init() {
        Graphics2D gfx;
        super.init();
        if (!this._label.isLaidOut() && (gfx = this._mgr.createGraphics()) != null) {
            gfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this._antiAliased ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
            this._label.layout(gfx);
            gfx.dispose();
        }
        Dimension size = this._label.getSize();
        this._bounds.width = size.width;
        this._bounds.height = size.height;
    }

    protected void paintAnimation(Graphics2D gfx) {
        Object ohints = null;
        if (this._antiAliased) {
            ohints = SwingUtil.activateAntiAliasing((Graphics2D)gfx);
        }
        this._label.render(gfx, (float)this._bounds.x, (float)this._bounds.y);
        if (this._antiAliased) {
            SwingUtil.restoreAntiAliasing((Graphics2D)gfx, (Object)ohints);
        }
    }
}

