/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.animation;

import com.google.common.collect.Lists;
import com.samskivert.util.StringUtil;
import com.threerings.media.Log;
import com.threerings.media.animation.Animation;
import com.threerings.media.animation.AnimationAdapter;
import com.threerings.media.animation.AnimationManager;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;

public class AnimationSequencer
extends Animation {
    protected AnimationManager _animmgr;
    protected ArrayList<AnimRecord> _queued = Lists.newArrayList();
    protected ArrayList<AnimRecord> _running = Lists.newArrayList();
    protected long _lastStamp;
    protected int _vdx;
    protected int _vdy;

    public AnimationSequencer(AnimationManager animmgr) {
        super(new Rectangle());
        this._animmgr = animmgr;
    }

    public void addAnimation(Animation anim, long delta, Runnable completionAction) {
        if (this._finished) {
            throw new IllegalStateException("Animation added to finished sequencer");
        }
        AnimRecord trigger = null;
        if (delta == -1L) {
            if (this._queued.size() > 0) {
                trigger = this._queued.get(this._queued.size() - 1);
            } else if (this._running.size() > 0) {
                trigger = this._running.get(this._running.size() - 1);
            }
        }
        AnimRecord arec = new AnimRecord(anim, delta, trigger, completionAction);
        this._queued.add(arec);
    }

    public void addAnimation(Animation anim) {
        this.addAnimation(anim, 0L, null);
    }

    public void appendAnimation(Animation anim) {
        this.addAnimation(anim, -1L, null);
    }

    public void clear() {
        this._queued.clear();
        this._lastStamp = 0L;
    }

    public void tick(long tickStamp) {
        if (this._lastStamp == 0L) {
            this._lastStamp = tickStamp;
        }
        while (this._queued.size() > 0) {
            AnimRecord arec = this._queued.get(0);
            if (!arec.readyToFire(tickStamp, this._lastStamp)) break;
            this._queued.remove(0);
            this._running.add(arec);
            this._lastStamp = tickStamp;
            arec.fire(tickStamp);
        }
        this._finished = this._queued.size() + this._running.size() == 0;
    }

    public void paint(Graphics2D gfx) {
    }

    public void fastForward(long timeDelta) {
        this._lastStamp += timeDelta;
    }

    public void viewLocationDidChange(int dx, int dy) {
        super.viewLocationDidChange(dx, dy);
        this._vdx += dx;
        this._vdy += dy;
    }

    protected void startAnimation(Animation anim, long tickStamp) {
        if (this._vdx != 0 || this._vdy != 0) {
            anim.viewLocationDidChange(this._vdx, this._vdy);
        }
        this._animmgr.registerAnimation(anim);
    }

    protected class AnimRecord
    extends AnimationAdapter {
        protected Animation _anim;
        protected Runnable _completionAction;
        protected long _delta;
        protected AnimRecord _trigger;

        public AnimRecord(Animation anim, long delta, AnimRecord trigger, Runnable completionAction) {
            this._anim = anim;
            this._delta = delta;
            this._trigger = trigger;
            this._completionAction = completionAction;
        }

        public boolean readyToFire(long now, long lastStamp) {
            if (this._delta == -1L) {
                return this._trigger == null ? true : !AnimationSequencer.this._running.contains(this._trigger);
            }
            return lastStamp + this._delta <= now;
        }

        public void fire(long when) {
            if (this._anim != null) {
                AnimationSequencer.this.startAnimation(this._anim, when);
                this._anim.addAnimationObserver(this);
            } else {
                this.fireCompletion(when);
            }
        }

        public void fireCompletion(long when) {
            if (this._completionAction != null) {
                try {
                    this._completionAction.run();
                }
                catch (Throwable t) {
                    Log.log.warning((Object)t, new Object[0]);
                }
            }
            AnimationSequencer.this._running.remove(this);
            AnimationSequencer.this.tick(when);
        }

        public void animationCompleted(Animation anim, long when) {
            this.fireCompletion(when);
        }

        public String toString() {
            return "[anim=" + StringUtil.shortClassName((Object)this._anim) + (this._anim == null ? "" : "/" + this._anim.hashCode()) + ", action=" + this._completionAction + ", delta=" + this._delta + ", trig=" + (this._trigger != null) + "]";
        }
    }
}

