/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media;

import com.google.common.collect.Maps;
import com.samskivert.util.ListUtil;
import com.samskivert.util.RunAnywhere;
import com.samskivert.util.StringUtil;
import com.threerings.media.FrameManager;
import com.threerings.media.Log;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Iterator;
import java.util.Map;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

public class ActiveRepaintManager
extends RepaintManager {
    protected Component _root;
    protected Object[] _invalid;
    protected Map<JComponent, Rectangle> _dirty = Maps.newHashMap();
    protected Map<JComponent, Rectangle> _spare = Maps.newHashMap();
    protected Rectangle _cbounds = new Rectangle();
    protected boolean[] _clipped = new boolean[]{true};
    protected static final boolean DEBUG = false;

    public ActiveRepaintManager(Component root) {
        this._root = root;
    }

    public synchronized void addInvalidComponent(JComponent comp) {
        Container vroot = null;
        Container c = comp;
        while (c != null) {
            if (!c.isDisplayable() || c instanceof CellRendererPane) {
                return;
            }
            if (c instanceof JComponent && !(c instanceof JTextField) && !(c instanceof JScrollPane) && ((JComponent)c).isValidateRoot()) {
                vroot = c;
                break;
            }
            c = c.getParent();
        }
        if (vroot == null) {
            return;
        }
        if (this.getRoot(vroot) == null) {
            return;
        }
        if (!ListUtil.containsRef((Object[])this._invalid, vroot)) {
            this._invalid = ListUtil.add((Object[])this._invalid, vroot);
        }
    }

    public synchronized void addDirtyRegion(JComponent comp, int x, int y, int width, int height) {
        if (width <= 0 || height <= 0 || comp == null || comp.getWidth() <= 0 || comp.getHeight() <= 0) {
            return;
        }
        Rectangle drect = this._dirty.get(comp);
        if (drect != null) {
            drect.add(x, y);
            drect.add(x + width, y + height);
            return;
        }
        if (this.getRoot(comp) == null) {
            return;
        }
        drect = new Rectangle(x, y, width, height);
        this._dirty.put(comp, drect);
    }

    protected Component getRoot(Component comp) {
        Component c = comp;
        while (c != null) {
            boolean hidden;
            boolean bl = hidden = !c.isDisplayable();
            if (!RunAnywhere.isMacOS()) {
                hidden |= !c.isVisible();
            }
            if (hidden) {
                return null;
            }
            if (c instanceof Window || c instanceof Applet) {
                return c;
            }
            c = c.getParent();
        }
        return null;
    }

    public synchronized Rectangle getDirtyRegion(JComponent comp) {
        Rectangle drect = this._dirty.get(comp);
        return drect == null ? new Rectangle(0, 0, 0, 0) : new Rectangle(drect);
    }

    public synchronized void markCompletelyClean(JComponent comp) {
        this._dirty.remove(comp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateComponents() {
        Object[] invalid = null;
        ActiveRepaintManager activeRepaintManager = this;
        synchronized (activeRepaintManager) {
            invalid = this._invalid;
            this._invalid = null;
        }
        if (invalid == null) {
            return;
        }
        int icount = invalid.length;
        int ii = 0;
        while (ii < icount) {
            if (invalid[ii] != null) {
                ((Component)invalid[ii]).validate();
            }
            ++ii;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean paintComponents(Graphics g, FrameManager fmgr) {
        Container c;
        Rectangle drect;
        JComponent comp;
        ActiveRepaintManager activeRepaintManager = this;
        synchronized (activeRepaintManager) {
            block22: {
                if (!this._dirty.isEmpty()) break block22;
                return false;
            }
            Map<JComponent, Rectangle> tmap = this._spare;
            this._spare = this._dirty;
            this._dirty = tmap;
        }
        Iterator<Map.Entry<JComponent, Rectangle>> iter = this._spare.entrySet().iterator();
        block9: while (iter.hasNext()) {
            Map.Entry<JComponent, Rectangle> entry = iter.next();
            comp = entry.getKey();
            drect = entry.getValue();
            int x = comp.getX() + drect.x;
            int y = comp.getY() + drect.y;
            c = comp.getParent();
            while (c != null) {
                if (!c.isVisible() || !c.isDisplayable() || !(c instanceof JComponent)) continue block9;
                Rectangle prect = this._spare.get(c);
                if (prect != null) {
                    drect.x = x;
                    drect.y = y;
                    prect.add(drect);
                    iter.remove();
                    continue block9;
                }
                x += c.getX();
                y += c.getY();
                c = c.getParent();
            }
        }
        for (Map.Entry<JComponent, Rectangle> entry : this._spare.entrySet()) {
            comp = entry.getKey();
            drect = entry.getValue();
            Container root = null;
            Container ocomp = null;
            this._cbounds.setBounds(0, 0, comp.getWidth(), comp.getHeight());
            c = comp;
            while (c != null) {
                if (!c.isVisible() || !c.isDisplayable()) break;
                if (c instanceof JComponent) {
                    if (ocomp == null && ((JComponent)c).isOpaque()) {
                        ocomp = c;
                        this._cbounds.setBounds(0, 0, ocomp.getWidth(), ocomp.getHeight());
                    }
                } else {
                    Container tp = c.getParent();
                    if (!(tp instanceof JEditorPane)) {
                        root = c;
                        break;
                    }
                }
                drect.x += c.getX();
                drect.y += c.getY();
                this._cbounds.x += c.getX();
                this._cbounds.y += c.getY();
                SwingUtilities.computeIntersection(c.getX(), c.getY(), c.getWidth(), c.getHeight(), drect);
                c = c.getParent();
            }
            if (ocomp == null) {
                ocomp = comp;
            }
            if (root == this._root) {
                g.setClip(drect);
                g.translate(this._cbounds.x, this._cbounds.y);
                try {
                    ((Component)ocomp).paint(g);
                }
                catch (Exception e) {
                    Log.log.warning((Object)"Exception while painting component", new Object[]{"comp", ocomp, e});
                }
                g.translate(-this._cbounds.x, -this._cbounds.y);
                fmgr.renderLayers((Graphics2D)g, ocomp, this._cbounds, this._clipped, drect);
                continue;
            }
            if (root == null) continue;
            Image obuf = this.getOffscreenBuffer(ocomp, this._cbounds.width, this._cbounds.height);
            Graphics og = null;
            Graphics cg = null;
            try {
                og = obuf.getGraphics();
                ((Component)ocomp).paint(og);
                cg = ocomp.getGraphics();
                cg.drawImage(obuf, 0, 0, null);
            }
            finally {
                if (og != null) {
                    og.dispose();
                }
                if (cg != null) {
                    cg.dispose();
                }
            }
        }
        this._spare.clear();
        return true;
    }

    protected static String toString(Component comp) {
        return String.valueOf(comp.getClass().getName()) + StringUtil.toString((Object)comp.getBounds());
    }

    protected static void dumpHierarchy(Component comp) {
        String indent = "";
        while (comp != null) {
            Log.log.info((Object)(String.valueOf(indent) + ActiveRepaintManager.toString(comp)), new Object[0]);
            comp = comp.getParent();
            indent = String.valueOf(indent) + " ";
        }
    }
}

