/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.chat;

import com.threerings.NenyaLog;
import com.threerings.chat.ChatLogic;
import com.threerings.crowd.chat.client.ChatDisplay;
import com.threerings.crowd.util.CrowdContext;
import com.threerings.media.VirtualMediaPanel;
import com.threerings.util.MessageBundle;
import com.threerings.util.Name;
import java.awt.Point;
import java.awt.Shape;
import java.util.List;

public abstract class ChatOverlay
implements ChatDisplay {
    protected CrowdContext _ctx;
    protected ChatLogic _logic;
    protected VirtualMediaPanel _target;
    protected InfoProvider _provider;
    protected boolean _dimmed;

    public void setVisible(boolean visible) {
    }

    public void setDimmed(boolean dimmed) {
        this._dimmed = dimmed;
    }

    public void added(VirtualMediaPanel target) {
        this._target = target;
    }

    public abstract void layout();

    public void removed() {
        this._target = null;
    }

    public void newPlaceEntered(InfoProvider provider) {
        this._provider = provider;
    }

    public void placeExited() {
        this._provider = null;
    }

    public VirtualMediaPanel getTarget() {
        return this._target;
    }

    public void speakerDeparted(Name speaker) {
    }

    public void viewDidScroll(int dx, int dy) {
    }

    protected ChatOverlay(CrowdContext ctx, ChatLogic logic) {
        this._ctx = ctx;
        this._logic = logic;
    }

    protected boolean isShowing() {
        return this._target != null && this._target.isShowing();
    }

    protected String xlate(String message) {
        return this.xlate(this._logic.getDefaultMessageBundle(), message);
    }

    protected String xlate(String bundle, String message) {
        if (bundle != null) {
            MessageBundle msgb = this._ctx.getMessageManager().getBundle(bundle);
            if (msgb == null) {
                NenyaLog.log.warning((Object)"No message bundle available to translate message", new Object[]{"bundle", bundle, "message", message});
            } else {
                message = msgb.xlate(message);
            }
        }
        return message;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface InfoProvider {
        public void getAvoidables(Name var1, List<Shape> var2, List<Shape> var3);

        public Point getSpeaker(Name var1);
    }
}

