/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.chat;

import com.samskivert.swing.Label;
import com.samskivert.util.Tuple;
import java.awt.Color;
import java.awt.Font;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChatLogic {
    public static final int DEFAULT_CHAT_DECAY = 1;
    public static final int PAD = 10;
    public static final int SPEAK = 0;
    public static final int SHOUT = 1;
    public static final int EMOTE = 2;
    public static final int THINK = 3;
    public static final int PLACE = 16;
    public static final int SPECIALIZED = 64;
    public static final int TELL = 80;
    public static final int TELLFEEDBACK = 96;
    public static final int INFO = 112;
    public static final int FEEDBACK = 128;
    public static final int ATTENTION = 144;
    public static final int CONTINUATION = 160;
    public static final int BROADCAST = 176;
    public static final int IGNORECHAT = -1;
    protected static final long[][] DISPLAY_DURATION_PARAMS = new long[][]{{125L, 10000L, 30000L}, {200L, 15000L, 40000L}, {275L, 20000L, 50000L}, {350L, 25000L, 60000L}};
    protected static final Color BROADCAST_COLOR = new Color(0x990000);
    protected static final Color FEEDBACK_COLOR = new Color(43520);
    protected static final Color TELL_COLOR = new Color(170);
    protected static final Color TELLFEEDBACK_COLOR = new Color(43690);
    protected static final Color INFO_COLOR = new Color(0xAAAA00);
    protected static final Color ATTENTION_COLOR = new Color(0xFF5000);
    protected static final Font DEFAULT_FONT = new Font("SansSerif", 0, 12);

    public abstract String getDefaultMessageBundle();

    public Tuple<String, Boolean> decodeFormat(int type, String format) {
        boolean quotes = true;
        switch (ChatLogic.placeOf(type)) {
            case 16: {
                switch (ChatLogic.modeOf(type)) {
                    case 2: {
                        quotes = false;
                    }
                }
            }
        }
        return Tuple.newTuple((Object)format, (Object)quotes);
    }

    public int decodeType(String localtype) {
        if ("userChat".equals(localtype)) {
            return 80;
        }
        if ("placeChat".equals(localtype)) {
            return 16;
        }
        return 0;
    }

    public int adjustTypeByMode(int mode, int type) {
        switch (mode) {
            case 0: {
                return type;
            }
            case 2: {
                return type | 2;
            }
            case 1: {
                return type | 3;
            }
            case 3: {
                return type | 1;
            }
            case 4: {
                return 176;
            }
        }
        return type;
    }

    public Font getFont(int type) {
        return DEFAULT_FONT;
    }

    public Label createLabel(String text) {
        return new Label(text);
    }

    public Color getOutlineColor(int type) {
        switch (type) {
            case 176: {
                return BROADCAST_COLOR;
            }
            case 80: {
                return TELL_COLOR;
            }
            case 96: {
                return TELLFEEDBACK_COLOR;
            }
            case 112: {
                return INFO_COLOR;
            }
            case 128: {
                return FEEDBACK_COLOR;
            }
            case 144: {
                return ATTENTION_COLOR;
            }
        }
        return Color.black;
    }

    public Shape getSubtitleShape(int type, Rectangle r, Rectangle b) {
        int placeType = ChatLogic.placeOf(type);
        switch (placeType) {
            case 16: 
            case 64: {
                return this.getPlaceSubtitleShape(type, r);
            }
            case 80: {
                int halfy = r.y + r.height / 2;
                Polygon p = new Polygon();
                p.addPoint(r.x - 10 - 2, r.y);
                p.addPoint(r.x - 5 - 2, halfy);
                p.addPoint(r.x - 10, halfy);
                p.addPoint(r.x - 5, r.y + r.height);
                p.addPoint(r.x + r.width + 10 + 2, r.y + r.height);
                p.addPoint(r.x + r.width + 5 + 2, halfy);
                p.addPoint(r.x + r.width + 10, halfy);
                p.addPoint(r.x + r.width + 5, r.y);
                return p;
            }
            case 96: {
                int halfy = r.y + r.height / 2;
                Polygon p = new Polygon();
                p.addPoint(r.x - 10 - 2, r.y + r.height);
                p.addPoint(r.x - 5 - 2, halfy);
                p.addPoint(r.x - 10, halfy);
                p.addPoint(r.x - 5, r.y);
                p.addPoint(r.x + r.width + 10 + 2, r.y);
                p.addPoint(r.x + r.width + 5 + 2, halfy);
                p.addPoint(r.x + r.width + 10, halfy);
                p.addPoint(r.x + r.width + 5, r.y + r.height);
                return p;
            }
            case 128: {
                Polygon p = new Polygon();
                p.addPoint(r.x - 5, r.y);
                p.addPoint(r.x + r.width + 10, r.y);
                p.addPoint(r.x + r.width + 5, r.y + r.height);
                p.addPoint(r.x - 10, r.y + r.height);
                return p;
            }
        }
        Rectangle grown = new Rectangle(r);
        grown.grow(10, 0);
        return new Area(grown);
    }

    public int getSubtitleSpacing(int type) {
        ChatLogic.placeOf(type);
        return 1;
    }

    public Shape getPlaceSubtitleShape(int type, Rectangle r) {
        switch (ChatLogic.modeOf(type)) {
            default: {
                Area a = new Area(r);
                a.add(new Area(new Ellipse2D.Float(r.x - 10, r.y, 20.0f, r.height)));
                a.add(new Area(new Ellipse2D.Float(r.x + r.width - 10, r.y, 20.0f, r.height)));
                return a;
            }
            case 3: {
                r.grow(5, 0);
                Area a = new Area(r);
                int dia = 8;
                int num = (int)Math.ceil((float)r.height / (float)dia);
                int leftside = r.x - dia / 2;
                int rightside = r.x + r.width - dia / 2 - 1;
                int maxh = r.height - dia;
                int ii = 0;
                while (ii < num) {
                    int ypos = r.y + Math.min(r.height * ii / num, maxh);
                    a.add(new Area(new Ellipse2D.Float(leftside, ypos, dia, dia)));
                    a.add(new Area(new Ellipse2D.Float(rightside, ypos, dia, dia)));
                    ++ii;
                }
                return a;
            }
            case 1: {
                r.grow(5, 0);
                Area a = new Area(r);
                Polygon left = new Polygon();
                Polygon right = new Polygon();
                int spikehei = 8;
                int num = (int)Math.ceil((float)r.height / (float)spikehei);
                left.addPoint(r.x, r.y);
                left.addPoint(r.x - 10, r.y + spikehei / 2);
                left.addPoint(r.x, r.y + spikehei);
                right.addPoint(r.x + r.width, r.y);
                right.addPoint(r.x + r.width + 10, r.y + spikehei / 2);
                right.addPoint(r.x + r.width, r.y + spikehei);
                int ypos = 0;
                int maxpos = r.y + r.height - spikehei + 1;
                int ii = 0;
                while (ii < num) {
                    int newpos = Math.min(r.height * ii / num, maxpos);
                    left.translate(0, newpos - ypos);
                    right.translate(0, newpos - ypos);
                    a.add(new Area(left));
                    a.add(new Area(right));
                    ypos = newpos;
                    ++ii;
                }
                return a;
            }
            case 2: 
        }
        r.grow(10, 0);
        Area a = new Area(r);
        a.subtract(new Area(new Ellipse2D.Float(r.x - 5, r.y, 10.0f, r.height)));
        a.subtract(new Area(new Ellipse2D.Float(r.x + r.width - 5, r.y, 10.0f, r.height)));
        return a;
    }

    public long[] getDisplayDurations(int indexOffset) {
        return DISPLAY_DURATION_PARAMS[this.getDisplayDurationIndex() + indexOffset];
    }

    protected int getDisplayDurationIndex() {
        return 1;
    }

    protected static int modeOf(int type) {
        return type & 0xF;
    }

    protected static int placeOf(int type) {
        return type & 0xFFFFFFF0;
    }
}

