/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.util;

import com.samskivert.util.Interval;
import com.samskivert.util.RunQueue;
import com.threerings.NenyaLog;
import com.threerings.util.KeyboardManager;
import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public abstract class IdleTracker {
    protected long _toIdleTime;
    protected long _toAbandonTime;
    protected long _lastEvent;
    protected int _state = 0;
    protected static final int ACTIVE = 0;
    protected static final int IDLE = 1;
    protected static final int ABANDONED = 2;
    protected static final long EVENT_MASK = 131128L;

    public IdleTracker(long toIdleTime, long toAbandonTime) {
        this._toIdleTime = toIdleTime;
        this._toAbandonTime = toAbandonTime;
        this._lastEvent = this.getTimeStamp();
    }

    public void start(KeyboardManager keymgr, RunQueue rqueue) {
        this.start(keymgr, null, rqueue);
    }

    public void start(KeyboardManager keymgr, Window root, RunQueue rqueue) {
        block3: {
            EventListener listener = new EventListener();
            try {
                Toolkit.getDefaultToolkit().addAWTEventListener(listener, 131128L);
            }
            catch (SecurityException se) {
                if (root == null) break block3;
                root.addKeyListener(listener);
                root.addMouseListener(listener);
                root.addMouseMotionListener(listener);
            }
        }
        if (keymgr != null) {
            keymgr.registerKeyObserver(new KeyboardManager.KeyObserver(){

                public void handleKeyEvent(int id, int keyCode, long timestamp) {
                    IdleTracker.this.handleUserActivity();
                }
            });
        }
        new Interval(rqueue){

            public void expired() {
                IdleTracker.this.checkIdle();
            }
        }.schedule(this._toIdleTime / 3L, true);
    }

    protected abstract void idledOut();

    protected abstract void idledIn();

    protected abstract void abandonedShip();

    protected abstract long getTimeStamp();

    protected void handleUserActivity() {
        this._lastEvent = this.getTimeStamp();
        if (this._state != 0) {
            this._state = 0;
            this.idledIn();
        }
    }

    protected void checkIdle() {
        long now = this.getTimeStamp();
        switch (this._state) {
            case 0: {
                if (now < this._lastEvent + this._toIdleTime) break;
                NenyaLog.log.info((Object)("User idle for " + (now - this._lastEvent) + "ms."), new Object[0]);
                this._state = 1;
                this.idledOut();
                break;
            }
            case 1: {
                if (now < this._lastEvent + this._toIdleTime + this._toAbandonTime) break;
                NenyaLog.log.info((Object)("User idle for " + (now - this._lastEvent) + "ms. " + "Abandoning ship."), new Object[0]);
                this._state = 2;
                this.abandonedShip();
            }
        }
    }

    protected class EventListener
    implements AWTEventListener,
    KeyListener,
    MouseListener,
    MouseMotionListener {
        protected EventListener() {
        }

        public void eventDispatched(AWTEvent event) {
            IdleTracker.this.handleUserActivity();
        }

        public void keyTyped(KeyEvent e) {
            this.eventDispatched(e);
        }

        public void keyPressed(KeyEvent e) {
            this.eventDispatched(e);
        }

        public void keyReleased(KeyEvent e) {
            this.eventDispatched(e);
        }

        public void mouseClicked(MouseEvent e) {
            this.eventDispatched(e);
        }

        public void mousePressed(MouseEvent e) {
            this.eventDispatched(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.eventDispatched(e);
        }

        public void mouseEntered(MouseEvent e) {
            this.eventDispatched(e);
        }

        public void mouseExited(MouseEvent e) {
            this.eventDispatched(e);
        }

        public void mouseDragged(MouseEvent e) {
            this.eventDispatched(e);
        }

        public void mouseMoved(MouseEvent e) {
            this.eventDispatched(e);
        }
    }
}

