/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.util;

import com.samskivert.util.IntListUtil;
import com.threerings.util.DirectionCodes;
import java.awt.Point;

public class DirectionUtil
implements DirectionCodes {
    protected static final String[] DIR_STRINGS = new String[]{"SOUTHWEST", "WEST", "NORTHWEST", "NORTH", "NORTHEAST", "EAST", "SOUTHEAST", "SOUTH", "WESTSOUTHWEST", "WESTNORTHWEST", "NORTHNORTHWEST", "NORTHNORTHEAST", "EASTNORTHEAST", "EASTSOUTHEAST", "SOUTHSOUTHEAST", "SOUTHSOUTHWEST"};
    protected static final String[] SHORT_DIR_STRINGS = new String[]{"SW", "W", "NW", "N", "NE", "E", "SE", "S", "WSW", "WNW", "NNW", "NNE", "ENE", "ESE", "SSE", "SSW"};
    protected static final int[] FINE_CW_ROTATE = new int[]{8, 9, 10, 11, 12, 13, 14, 15, 1, 2, 3, 4, 5, 6, 7, 0};
    protected static final int[] FINE_CCW_ROTATE = new int[]{15, 8, 9, 10, 11, 12, 13, 14, 0, 1, 2, 3, 4, 5, 6, 7};
    protected static final int[] ANGLE_MAP = new int[]{1, 9, 2, 10, 3, 11, 4, 12, 5, 13, 6, 14, 7, 15, 0, 8};

    public static String[] getDirectionNames() {
        return DIR_STRINGS;
    }

    public static String toString(int direction) {
        return direction >= 0 && direction < 16 ? DIR_STRINGS[direction] : "INVALID";
    }

    public static String toShortString(int direction) {
        return direction >= 0 && direction < 16 ? SHORT_DIR_STRINGS[direction] : "?";
    }

    public static int fromString(String dirstr) {
        for (int ii = 0; ii < 16; ++ii) {
            if (!DIR_STRINGS[ii].equals(dirstr)) continue;
            return ii;
        }
        return -1;
    }

    public static int fromShortString(String dirstr) {
        for (int ii = 0; ii < 16; ++ii) {
            if (!SHORT_DIR_STRINGS[ii].equals(dirstr)) continue;
            return ii;
        }
        return -1;
    }

    public static String toString(int[] directions) {
        StringBuilder buf = new StringBuilder("{");
        for (int ii = 0; ii < directions.length; ++ii) {
            if (ii > 0) {
                buf.append(", ");
            }
            buf.append(DirectionUtil.toShortString(directions[ii]));
        }
        return buf.append("}").toString();
    }

    public static int rotateCW(int direction, int ticks) {
        for (int ii = 0; ii < ticks; ++ii) {
            direction = FINE_CW_ROTATE[direction];
        }
        return direction;
    }

    public static int rotateCCW(int direction, int ticks) {
        for (int ii = 0; ii < ticks; ++ii) {
            direction = FINE_CCW_ROTATE[direction];
        }
        return direction;
    }

    public static int getOpposite(int direction) {
        return DirectionUtil.rotateCW(direction, FINE_CW_ROTATE.length / 2);
    }

    public static int getClosestCardinal(int direction) {
        return DirectionUtil.getClosest(direction, CARDINAL_DIRECTIONS, true);
    }

    public static int getClosest(int direction, int[] possible) {
        return DirectionUtil.getClosest(direction, possible, true);
    }

    public static int getClosest(int direction, int[] possible, boolean preferCW) {
        int first = direction;
        int second = direction;
        for (int ii = 0; ii <= 8; ++ii) {
            if (IntListUtil.contains((int[])possible, (int)first)) {
                return first;
            }
            if (ii != 0 && IntListUtil.contains((int[])possible, (int)second)) {
                return second;
            }
            first = preferCW ? DirectionUtil.rotateCW(first, 1) : DirectionUtil.rotateCCW(first, 1);
            second = preferCW ? DirectionUtil.rotateCCW(second, 1) : DirectionUtil.rotateCW(second, 1);
        }
        return -1;
    }

    public static int getDirection(Point a, Point b) {
        return DirectionUtil.getDirection(a.getX(), a.getY(), b.getX(), b.getY());
    }

    public static int getDirection(int ax, int ay, int bx, int by) {
        return DirectionUtil.getDirection(Math.atan2(by - ay, bx - ax));
    }

    public static int getDirection(double ax, double ay, double bx, double by) {
        return DirectionUtil.getDirection(Math.atan2(by - ay, bx - ax));
    }

    public static int getDirection(double theta) {
        theta = (theta + Math.PI) * 4.0 / Math.PI;
        return (int)(Math.round(theta) + 1L) % 8;
    }

    public static int getFineDirection(Point a, Point b) {
        return DirectionUtil.getFineDirection(a.x, a.y, b.x, b.y);
    }

    public static int getFineDirection(int ax, int ay, int bx, int by) {
        return DirectionUtil.getFineDirection(Math.atan2(by - ay, bx - ax));
    }

    public static int getFineDirection(double theta) {
        theta = (theta + Math.PI) * 8.0 / Math.PI;
        return ANGLE_MAP[(int)Math.round(theta) % 16];
    }

    public static void moveDirection(Point p, int direction, int dx, int dy) {
        if (direction >= 8) {
            throw new IllegalArgumentException("Fine coordinates not supported.");
        }
        switch (direction) {
            case 2: 
            case 3: 
            case 4: {
                p.y -= dy;
            }
        }
        switch (direction) {
            case 0: 
            case 6: 
            case 7: {
                p.y += dy;
            }
        }
        switch (direction) {
            case 0: 
            case 1: 
            case 2: {
                p.x -= dx;
            }
        }
        switch (direction) {
            case 4: 
            case 5: 
            case 6: {
                p.x += dx;
            }
        }
    }
}

