/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.openal;

import com.google.common.collect.Lists;
import com.threerings.openal.SoundManager;
import com.threerings.openal.Stream;
import com.threerings.openal.StreamDecoder;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class URLStream
extends Stream {
    protected QueuedURL _url;
    protected StreamDecoder _decoder;
    protected ArrayList<QueuedURL> _queue = Lists.newArrayList();

    public URLStream(SoundManager soundmgr, URL url, boolean loop) throws IOException {
        super(soundmgr);
        this._url = new QueuedURL(url, loop);
        this._decoder = StreamDecoder.createInstance(url);
    }

    public void queueURL(URL url, boolean loop) {
        this._queue.add(new QueuedURL(url, loop));
    }

    protected int getFormat() {
        return this._decoder.getFormat();
    }

    protected int getFrequency() {
        return this._decoder.getFrequency();
    }

    protected int populateBuffer(ByteBuffer buf) throws IOException {
        int read = this._decoder.read(buf);
        while (buf.hasRemaining() && (!this._queue.isEmpty() || this._url.loop)) {
            if (!this._queue.isEmpty()) {
                this._url = this._queue.remove(0);
            }
            this._decoder = StreamDecoder.createInstance(this._url.url);
            read = Math.max(0, read);
            read += this._decoder.read(buf);
        }
        return read;
    }

    protected class QueuedURL {
        public URL url;
        public boolean loop;

        public QueuedURL(URL url, boolean loop) {
            this.url = url;
            this.loop = loop;
        }
    }
}

