/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.openal;

import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;
import com.threerings.openal.StreamDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;

public class OggStreamDecoder
extends StreamDecoder {
    protected InputStream _in;
    protected SyncState _sync = new SyncState();
    protected StreamState _stream = new StreamState();
    protected Page _page = new Page();
    protected Packet _packet = new Packet();
    protected Info _info = new Info();
    protected DspState _dsp = new DspState();
    protected Block _block = new Block(this._dsp);
    protected float[][][] _pcm = new float[1][][];
    protected int[] _offsets;
    protected short[] _data = new short[0];
    protected static final int BUFFER_SIZE = 8192;

    public void init(InputStream in) throws IOException {
        this._in = in;
        this._sync.init();
        this._info.init();
        this.readChunk();
        if (this._sync.pageout(this._page) != 1) {
            throw new IOException("Input is not an Ogg bitstream.");
        }
        this._stream.init(this._page.serialno());
        this._stream.reset();
        if (this._stream.pagein(this._page) < 0) {
            throw new IOException("Error reading first page of Ogg bitstream data.");
        }
        if (this._stream.packetout(this._packet) != 1) {
            throw new IOException("Error reading initial header packet.");
        }
        Comment comment = new Comment();
        comment.init();
        if (this._info.synthesis_headerin(comment, this._packet) < 0) {
            throw new IOException("Ogg bitstream does not contain Vorbis audio data.");
        }
        for (int ii = 0; ii < 2; ++ii) {
            if (!this.readPacket()) {
                throw new IOException("End of file before reading all Vorbis headers.");
            }
            this._info.synthesis_headerin(comment, this._packet);
        }
        this._dsp.synthesis_init(this._info);
        this._block.init(this._dsp);
        this._offsets = new int[this._info.channels];
    }

    public int getFormat() {
        return this._info.channels == 1 ? 4353 : 4355;
    }

    public int getFrequency() {
        return this._info.rate;
    }

    public int read(ByteBuffer buf) throws IOException {
        int samples;
        ShortBuffer sbuf = buf.asShortBuffer();
        int channels = this._info.channels;
        int total = 0;
        while (sbuf.hasRemaining() && (samples = Math.min(this.readSamples(), sbuf.remaining() / channels)) != 0) {
            int length = samples * channels;
            if (this._data.length < length) {
                this._data = new short[length];
            }
            short[] data = this._data;
            for (int ii = 0; ii < channels; ++ii) {
                float[] pcm = this._pcm[0][ii];
                int sidx = this._offsets[ii];
                int didx = ii;
                for (int jj = 0; jj < samples; ++jj) {
                    float value = Math.min(Math.max(pcm[sidx], -1.0f), 1.0f);
                    data[didx] = (short)(value * 32767.0f);
                    ++sidx;
                    didx += channels;
                }
            }
            sbuf.put(this._data, 0, length);
            this._dsp.synthesis_read(samples);
            total += length * 2;
        }
        buf.position(buf.position() + total);
        return total;
    }

    protected int readSamples() throws IOException {
        int samples;
        while ((samples = this._dsp.synthesis_pcmout(this._pcm, this._offsets)) <= 0) {
            if (samples == 0 && !this.readPacket()) {
                return 0;
            }
            if (this._block.synthesis(this._packet) != 0) continue;
            this._dsp.synthesis_blockin(this._block);
        }
        return samples;
    }

    protected boolean readPacket() throws IOException {
        int result;
        while ((result = this._stream.packetout(this._packet)) != 1) {
            if (result != 0 || this.readPage()) continue;
            return false;
        }
        return true;
    }

    protected boolean readPage() throws IOException {
        int result;
        while ((result = this._sync.pageout(this._page)) != 1) {
            if (result != 0 || this.readChunk()) continue;
            return false;
        }
        this._stream.pagein(this._page);
        return true;
    }

    protected boolean readChunk() throws IOException {
        int offset = this._sync.buffer(8192);
        int bytes = this._in.read(this._sync.data, offset, 8192);
        if (bytes > 0) {
            this._sync.wrote(bytes);
            return true;
        }
        return false;
    }
}

