/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.cast.builder;

import com.threerings.cast.CharacterDescriptor;
import com.threerings.cast.CharacterManager;
import com.threerings.cast.CharacterSprite;
import com.threerings.cast.builder.BuilderModel;
import com.threerings.cast.builder.BuilderModelListener;
import com.threerings.util.DirectionCodes;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;

public class SpritePanel
extends JPanel
implements DirectionCodes,
BuilderModelListener {
    protected CharacterSprite _sprite;
    protected CharacterManager _charmgr;
    protected BuilderModel _model;

    public SpritePanel(CharacterManager charmgr, BuilderModel model) {
        this._charmgr = charmgr;
        this._model = model;
        this._model.addListener(this);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D gfx = (Graphics2D)g;
        if (this._sprite != null) {
            this._sprite.paint(gfx);
        }
    }

    public void doLayout() {
        super.doLayout();
        this.generateSprite();
        this.centerSprite();
    }

    public void modelChanged(int event) {
        if (event == 0) {
            this.generateSprite();
        }
    }

    protected void generateSprite() {
        int[] components = this._model.getSelectedComponents();
        CharacterDescriptor desc = new CharacterDescriptor(components, null);
        CharacterSprite sprite = this._charmgr.getCharacter(desc);
        this.setSprite(sprite);
    }

    protected void setSprite(CharacterSprite sprite) {
        sprite.setActionSequence("standing");
        sprite.setOrientation(1);
        this._sprite = sprite;
        this.centerSprite();
        this.repaint();
    }

    protected void centerSprite() {
        if (this._sprite != null) {
            Dimension d = this.getSize();
            int shei = this._sprite.getHeight();
            int x = d.width / 2;
            int y = (d.height + shei) / 2;
            this._sprite.setLocation(x, y);
        }
    }
}

