/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.util;

import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.util.Comparator;
import java.util.TreeSet;

public class ModeUtil {
    public static DisplayMode getDisplayMode(GraphicsDevice gd, int width, int height, int desiredDepth, int minimumDepth) {
        DisplayMode[] modes = gd.getDisplayModes();
        final int ddepth = desiredDepth;
        Comparator<DisplayMode> mcomp = new Comparator<DisplayMode>(){

            @Override
            public int compare(DisplayMode m1, DisplayMode m2) {
                int bd1 = m1.getBitDepth();
                int bd2 = m2.getBitDepth();
                int rr1 = m1.getRefreshRate();
                int rr2 = m2.getRefreshRate();
                if (bd1 == ddepth && bd2 != ddepth) {
                    return -1;
                }
                if (bd2 == ddepth && bd1 != ddepth) {
                    return 1;
                }
                if (bd1 != bd2) {
                    return bd2 - bd1;
                }
                return rr2 - rr1;
            }
        };
        TreeSet<DisplayMode> mset = new TreeSet<DisplayMode>(mcomp);
        DisplayMode[] displayModeArray = modes;
        int n = modes.length;
        int n2 = 0;
        while (n2 < n) {
            DisplayMode mode = displayModeArray[n2];
            if (mode.getWidth() == width && mode.getHeight() == height && mode.getBitDepth() >= minimumDepth && mode.getRefreshRate() <= 75) {
                mset.add(mode);
            }
            ++n2;
        }
        return mset.size() > 0 ? mset.first() : null;
    }

    public static String toString(DisplayMode mode) {
        return "[width=" + mode.getWidth() + ", height=" + mode.getHeight() + ", depth=" + mode.getBitDepth() + ", refresh=" + mode.getRefreshRate() + "]";
    }
}

