/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.tile.bundle;

import com.samskivert.util.HashIntMap;
import com.samskivert.util.IntMap;
import com.threerings.media.image.ImageDataProvider;
import com.threerings.media.tile.TileSet;
import com.threerings.resource.ResourceBundle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;

public class TileSetBundle
extends HashIntMap<TileSet>
implements ImageDataProvider {
    protected transient ResourceBundle _bundle;
    private static final long serialVersionUID = 2L;

    public void init(ResourceBundle bundle) {
        this._bundle = bundle;
    }

    public final void addTileSet(int tileSetId, TileSet set) {
        this.put(tileSetId, set);
    }

    public final TileSet getTileSet(int tileSetId) {
        return (TileSet)this.get(tileSetId);
    }

    public Iterator<Integer> enumerateTileSetIds() {
        return this.keySet().iterator();
    }

    public Iterator<TileSet> enumerateTileSets() {
        return this.values().iterator();
    }

    @Override
    public String getIdent() {
        return "tsb:" + this._bundle.getIdent();
    }

    @Override
    public BufferedImage loadImage(String path) throws IOException {
        return this._bundle.getImageResource(path, path.endsWith(".raw"));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.size());
        for (IntMap.IntEntry entry : this.intEntrySet()) {
            out.writeInt(entry.getIntKey());
            out.writeObject(entry.getValue());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int count = in.readInt();
        int ii = 0;
        while (ii < count) {
            int tileSetId = in.readInt();
            TileSet set = (TileSet)in.readObject();
            this.put(tileSetId, set);
            ++ii;
        }
    }
}

