/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.image;

import com.google.common.collect.Lists;
import com.samskivert.util.HashIntMap;
import com.samskivert.util.RandomUtil;
import com.samskivert.util.StringUtil;
import com.threerings.media.Log;
import com.threerings.media.image.Colorization;
import com.threerings.resource.ResourceManager;
import com.threerings.util.CompiledConfig;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;

public class ColorPository
implements Serializable {
    protected HashIntMap<ClassRecord> _classes = new HashIntMap();
    private static final long serialVersionUID = 1L;
    protected static final String CONFIG_PATH = "config/media/colordefs.dat";

    public Iterator<ClassRecord> enumerateClasses() {
        return this._classes.values().iterator();
    }

    public Collection<ClassRecord> getClasses() {
        return this._classes.values();
    }

    public ColorRecord[] enumerateColors(String className) {
        ClassRecord record = this.getClassRecord(className);
        if (record == null) {
            return null;
        }
        ColorRecord[] crecs = new ColorRecord[record.colors.size()];
        Iterator iter = record.colors.values().iterator();
        int ii = 0;
        while (iter.hasNext()) {
            crecs[ii] = (ColorRecord)iter.next();
            ++ii;
        }
        return crecs;
    }

    public int[] enumerateColorIds(String className) {
        ClassRecord record = this.getClassRecord(className);
        if (record == null) {
            return null;
        }
        int[] cids = new int[record.colors.size()];
        Iterator crecs = record.colors.values().iterator();
        int ii = 0;
        while (crecs.hasNext()) {
            cids[ii] = ((ColorRecord)crecs.next()).colorId;
            ++ii;
        }
        return cids;
    }

    public boolean isLegalStartColor(int colorPrint) {
        ColorRecord color = this.getColorRecord(colorPrint >> 8, colorPrint & 0xFF);
        return color == null ? false : color.starter;
    }

    public boolean isLegalStartColor(int classId, int colorId) {
        ColorRecord color = this.getColorRecord(classId, colorId);
        return color == null ? false : color.starter;
    }

    public ColorRecord getRandomStartingColor(String className) {
        return this.getRandomStartingColor(className, RandomUtil.rand);
    }

    public ColorRecord getRandomStartingColor(String className, Random rand) {
        ClassRecord record = this.getClassRecord(className);
        return record == null ? null : record.randomStartingColor(rand);
    }

    public Colorization getColorization(int classId, int colorId) {
        ColorRecord color = this.getColorRecord(classId, colorId);
        return color == null ? null : color.getColorization();
    }

    public Colorization getColorization(int colorPrint) {
        return this.getColorization(colorPrint >> 8, colorPrint & 0xFF);
    }

    public Colorization getColorization(String className, int colorId) {
        ColorRecord color;
        ClassRecord crec = this.getClassRecord(className);
        if (crec != null && (color = (ColorRecord)crec.colors.get(colorId)) != null) {
            return color.getColorization();
        }
        return null;
    }

    public Colorization getColorization(String className, String colorName) {
        ClassRecord crec = this.getClassRecord(className);
        if (crec != null) {
            int colorId = 0;
            try {
                colorId = crec.getColorId(colorName);
            }
            catch (ParseException pe) {
                Log.log.info((Object)"Error getting colorization by name", new Object[]{"error", pe});
                return null;
            }
            ColorRecord color = (ColorRecord)crec.colors.get(colorId);
            if (color != null) {
                return color.getColorization();
            }
        }
        return null;
    }

    public ClassRecord getClassRecord(String className) {
        for (ClassRecord crec : this._classes.values()) {
            if (!crec.name.equals(className)) continue;
            return crec;
        }
        Log.log.warning((Object)"No such color class", new Object[]{"class", className, new Exception()});
        return null;
    }

    public ColorRecord getColorRecord(int classId, int colorId) {
        ClassRecord record = this.getClassRecord(classId);
        if (record == null) {
            if (classId != 0) {
                Log.log.warning((Object)"Requested unknown color class", new Object[]{"classId", classId, "colorId", colorId, new Exception()});
            }
            return null;
        }
        return (ColorRecord)record.colors.get(colorId);
    }

    public ColorRecord getColorRecord(String className, String colorName) {
        ClassRecord record = this.getClassRecord(className);
        if (record == null) {
            Log.log.warning((Object)"Requested unknown color class", new Object[]{"className", className, "colorName", colorName, new Exception()});
            return null;
        }
        int colorId = 0;
        try {
            colorId = record.getColorId(colorName);
        }
        catch (ParseException pe) {
            Log.log.info((Object)"Error getting color record by name", new Object[]{"error", pe});
            return null;
        }
        return (ColorRecord)record.colors.get(colorId);
    }

    public ClassRecord getClassRecord(int classId) {
        return (ClassRecord)this._classes.get(classId);
    }

    public void addClass(ClassRecord record) {
        if (record.classId > 255) {
            Log.log.warning((Object)("Refusing to add class; classId > 255 " + record + "."), new Object[0]);
        } else {
            this._classes.put(record.classId, (Object)record);
        }
    }

    public static ColorPository loadColorPository(ResourceManager rmgr) {
        try {
            return ColorPository.loadColorPository(rmgr.getResource(CONFIG_PATH));
        }
        catch (IOException ioe) {
            Log.log.warning((Object)"Failure loading color pository", new Object[]{"path", CONFIG_PATH, "error", ioe});
            return new ColorPository();
        }
    }

    public static ColorPository loadColorPository(InputStream source) {
        try {
            return (ColorPository)CompiledConfig.loadConfig(source);
        }
        catch (IOException ioe) {
            Log.log.warning((Object)"Failure loading color pository", new Object[]{"ioe", ioe});
            return new ColorPository();
        }
    }

    public static void saveColorPository(ColorPository posit, File root) {
        File path = new File(root, CONFIG_PATH);
        try {
            CompiledConfig.saveConfig(path, posit);
        }
        catch (IOException ioe) {
            Log.log.warning((Object)"Failure saving color pository", new Object[]{"path", path, "error", ioe});
        }
    }

    public static class ClassRecord
    implements Serializable,
    Comparable<ClassRecord> {
        public int classId;
        public String name;
        public Color source;
        public float[] range;
        public boolean starter;
        public int defaultId;
        public HashIntMap<ColorRecord> colors = new HashIntMap();
        protected transient float[] _hsv;
        protected transient int[] _fhsv;
        protected transient ColorRecord[] _starters;
        private static final long serialVersionUID = 2L;

        public void addColor(ColorRecord record) {
            if (record.colorId > 127) {
                Log.log.warning((Object)"Refusing to add color record; colorId > 127", new Object[]{"class", this, "record", record});
            } else if (this.colors.containsKey(record.colorId)) {
                Log.log.warning((Object)"Refusing to add duplicate colorId", new Object[]{"class", this, "record", record, "existing", this.colors.get(record.colorId)});
            } else {
                record.cclass = this;
                this.colors.put(record.colorId, (Object)record);
            }
        }

        public int getColorId(String name) throws ParseException {
            try {
                int id = Integer.parseInt(name);
                if (this.colors.containsKey(id)) {
                    return id;
                }
            }
            catch (NumberFormatException id) {
                // empty catch block
            }
            for (ColorRecord color : this.colors.values()) {
                if (!color.name.equalsIgnoreCase(name)) continue;
                return color.colorId;
            }
            throw new ParseException("No color named '" + name + "'", 0);
        }

        public ColorRecord randomStartingColor() {
            return this.randomStartingColor(RandomUtil.rand);
        }

        public ColorRecord randomStartingColor(Random rand) {
            if (this._starters == null) {
                ArrayList list = Lists.newArrayList();
                for (ColorRecord color : this.colors.values()) {
                    if (!color.starter) continue;
                    list.add(color);
                }
                this._starters = list.toArray(new ColorRecord[list.size()]);
            }
            if (this._starters.length < 1) {
                Log.log.warning((Object)"Requested random starting color from colorless component class", new Object[]{"class", this});
                return null;
            }
            return this._starters[RandomUtil.getInt((int)this._starters.length, (Random)rand)];
        }

        public ColorRecord getDefault() {
            return (ColorRecord)this.colors.get(this.defaultId);
        }

        @Override
        public int compareTo(ClassRecord other) {
            return this.name.compareTo(other.name);
        }

        public String toString() {
            return "[id=" + this.classId + ", name=" + this.name + ", source=#" + Integer.toString(this.source.getRGB() & 0xFFFFFF, 16) + ", range=" + StringUtil.toString((Object)this.range) + ", starter=" + this.starter + ", colors=" + StringUtil.toString(this.colors.values().iterator()) + "]";
        }

        protected void computeHsv() {
            if (this._hsv == null) {
                this._hsv = Color.RGBtoHSB(this.source.getRed(), this.source.getGreen(), this.source.getBlue(), null);
                this._fhsv = Colorization.toFixedHSV(this._hsv, null);
            }
        }
    }

    public static class ColorRecord
    implements Serializable,
    Comparable<ColorRecord> {
        public ClassRecord cclass;
        public int colorId;
        public String name;
        public float[] offsets;
        public boolean starter;
        protected transient Colorization _zation;
        private static final long serialVersionUID = 2L;

        public int getColorPrint() {
            return this.cclass.classId << 8 | this.colorId;
        }

        public Colorization getColorization() {
            return new Colorization(this.getColorPrint(), this.cclass, this.offsets);
        }

        @Override
        public int compareTo(ColorRecord other) {
            return this.name.compareTo(other.name);
        }

        public String toString() {
            return "[id=" + this.colorId + ", name=" + this.name + ", offsets=" + StringUtil.toString((Object)this.offsets) + ", starter=" + this.starter + "]";
        }
    }
}

