/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.animation;

import com.samskivert.swing.Label;
import com.threerings.media.animation.Animation;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class FloatingTextAnimation
extends Animation {
    protected long _start;
    protected Label _label;
    protected int _startX;
    protected int _startY;
    protected int _x;
    protected int _y;
    protected int _destx;
    protected int _desty;
    protected int _dx;
    protected int _dy;
    protected long _floatPeriod;
    protected float _alpha;
    protected Composite _comp;
    protected static final long DEFAULT_FLOAT_PERIOD = 1500L;
    protected static final int DELTA_Y = 30;

    public FloatingTextAnimation(Label label, int x, int y) {
        this(label, x, y, 1500L);
    }

    public FloatingTextAnimation(Label label, int x, int y, long floatPeriod) {
        this(label, x, y, x, y - 30, floatPeriod);
    }

    public FloatingTextAnimation(Label label, int sx, int sy, int destx, int desty, long floatPeriod) {
        super(new Rectangle(sx, sy, label.getSize().width, label.getSize().height));
        this._label = label;
        this._startX = this._x = sx;
        this._startY = this._y = sy;
        this._destx = destx;
        this._desty = desty;
        this._floatPeriod = floatPeriod;
        this._dx = destx - sx;
        this._dy = desty - sy;
        this._alpha = 1.0f;
    }

    public void flipDirection() {
        this._dx = -this._dx;
        this._dy = -this._dy;
    }

    public Label getLabel() {
        return this._label;
    }

    @Override
    public void setLocation(int x, int y) {
        super.setLocation(x, y);
        this._destx += x - this._startX;
        this._desty += y - this._startY;
        this._startX = this._x = x;
        this._startY = this._y = y;
        this._dx = this._destx - x;
        this._dy = this._desty - y;
    }

    public void setFloatPeriod(long floatPeriod) {
        this._floatPeriod = floatPeriod;
    }

    @Override
    public void tick(long timestamp) {
        boolean invalid = false;
        if (this._start == 0L) {
            this._start = timestamp;
            invalid = true;
        }
        long fadeDelay = this._floatPeriod / 2L;
        long fadePeriod = this._floatPeriod - fadeDelay;
        long msecs = timestamp - this._start;
        float oalpha = this._alpha;
        if (msecs > fadeDelay) {
            long rmsecs = msecs - fadeDelay;
            this._alpha = Math.max(1.0f - (float)rmsecs / (float)fadePeriod, 0.0f);
            this._alpha = Math.min(this._alpha, 1.0f);
        }
        this._comp = AlphaComposite.getInstance(3, this._alpha);
        float pctdone = (float)msecs / (float)this._floatPeriod;
        int ox = this._x;
        int oy = this._y;
        this._x = this._startX + (int)((float)this._dx * pctdone);
        this._y = this._startY + (int)((float)this._dy * pctdone);
        if (ox != this._x || oy != this._y) {
            this.invalidate();
            this._bounds.setLocation(this._x, this._y);
            invalid = true;
        } else if (oalpha != this._alpha) {
            invalid = true;
        }
        if (invalid) {
            this.invalidate();
        }
        this._finished = msecs >= this._floatPeriod;
    }

    @Override
    public void fastForward(long timeDelta) {
        if (this._start > 0L) {
            this._start += timeDelta;
        }
    }

    @Override
    public void paint(Graphics2D gfx) {
        Composite ocomp = gfx.getComposite();
        if (this._comp != null) {
            gfx.setComposite(this._comp);
        }
        this.paintLabels(gfx, this._x, this._y);
        gfx.setComposite(ocomp);
    }

    protected void paintLabels(Graphics2D gfx, int x, int y) {
        this._label.render(gfx, (float)x, (float)y);
    }

    @Override
    protected void toString(StringBuilder buf) {
        super.toString(buf);
        buf.append(", x=").append(this._x);
        buf.append(", y=").append(this._y);
        buf.append(", alpha=").append(this._alpha);
    }
}

