/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media;

import com.threerings.media.AbstractMedia;
import com.threerings.media.ActiveRepaintManager;
import com.threerings.media.FrameManager;
import com.threerings.media.MediaHost;
import com.threerings.media.MetaMediaManager;
import com.threerings.media.animation.Animation;
import com.threerings.media.animation.AnimationManager;
import com.threerings.media.sprite.Sprite;
import com.threerings.media.sprite.SpriteManager;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JRootPane;

public class MediaOverlay
implements MediaHost {
    protected FrameManager _framemgr;
    protected MetaMediaManager _metamgr;
    protected Rectangle[] _dirty;

    public AnimationManager getAnimationManager() {
        return this._metamgr.getAnimationManager();
    }

    public SpriteManager getSpriteManager() {
        return this._metamgr.getSpriteManager();
    }

    public void addSprite(Sprite sprite) {
        this._metamgr.addSprite(sprite);
    }

    public boolean isManaged(Sprite sprite) {
        return this._metamgr.isManaged(sprite);
    }

    public void removeSprite(Sprite sprite) {
        this._metamgr.removeSprite(sprite);
    }

    public void clearSprites() {
        this._metamgr.clearSprites();
    }

    public void addAnimation(Animation anim) {
        this._metamgr.addAnimation(anim);
    }

    public boolean isManaged(Animation anim) {
        return this._metamgr.isManaged(anim);
    }

    public void abortAnimation(Animation anim) {
        this._metamgr.abortAnimation(anim);
    }

    public void clearAnimations() {
        this._metamgr.clearAnimations();
    }

    public void addDirtyRegion(Rectangle rect) {
        for (AbstractMedia media : this._metamgr) {
            Rectangle intersection = media.getBounds().intersection(rect);
            if (intersection.isEmpty()) continue;
            this._metamgr.getRegionManager().addDirtyRegion(intersection);
        }
    }

    public void propagateDirtyRegions(ActiveRepaintManager repmgr, JRootPane root) {
        if (this._metamgr.needsPaint()) {
            List<Rectangle> dlist = this._metamgr.getRegionManager().peekDirtyRegions();
            int ii = 0;
            int ll = dlist.size();
            while (ii < ll) {
                Rectangle dirty = dlist.get(ii);
                repmgr.addDirtyRegion(root, dirty.x - root.getX(), dirty.y - root.getY(), dirty.width, dirty.height);
                ++ii;
            }
        }
    }

    public boolean paint(Graphics2D gfx) {
        Rectangle[] dirty;
        if (!this._metamgr.getRegionManager().haveDirtyRegions()) {
            return false;
        }
        Rectangle[] rectangleArray = dirty = this._metamgr.getRegionManager().getDirtyRegions();
        int n = dirty.length;
        int n2 = 0;
        while (n2 < n) {
            Rectangle element = rectangleArray[n2];
            gfx.setClip(element);
            this._metamgr.paintMedia(gfx, 1, element);
            this._metamgr.paintMedia(gfx, 2, element);
            ++n2;
        }
        return true;
    }

    @Override
    public Graphics2D createGraphics() {
        return this._metamgr.getFrameManager().createGraphics();
    }

    public void tick(long tickStamp) {
        if (!this._metamgr.isPaused()) {
            this._metamgr.tick(tickStamp);
        }
    }

    protected MediaOverlay(FrameManager fmgr) {
        this._framemgr = fmgr;
        this._metamgr = new MetaMediaManager(fmgr, this);
    }
}

