/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.openal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.samskivert.util.IntListUtil;
import com.samskivert.util.LRUHashMap;
import com.samskivert.util.Queue;
import com.samskivert.util.RunQueue;
import com.threerings.openal.Clip;
import com.threerings.openal.ClipBuffer;
import com.threerings.openal.ClipProvider;
import com.threerings.openal.Listener;
import com.threerings.openal.Log;
import com.threerings.openal.SoundGroup;
import com.threerings.openal.Stream;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;

public class SoundManager {
    protected Thread _loader = new Thread("SoundManager.Loader"){

        @Override
        public void run() {
            while (true) {
                final ClipBuffer buffer = (ClipBuffer)SoundManager.this._toLoad.get();
                try {
                    Log.log.debug((Object)("Loading " + buffer.getKey() + "."), new Object[0]);
                    final Clip clip = buffer.load();
                    SoundManager.this._rqueue.postRunnable(new Runnable(){

                        @Override
                        public void run() {
                            String ckey = buffer.getKey();
                            Log.log.debug((Object)("Loaded " + ckey + "."), new Object[0]);
                            SoundManager.this._loading.remove(ckey);
                            if (buffer.bind(clip)) {
                                SoundManager.this._clips.put((Object)ckey, (Object)buffer);
                            }
                        }
                    });
                    continue;
                }
                catch (Throwable t) {
                    Log.log.warning((Object)("Failed to load clip [key=" + buffer.getKey() + "]."), new Object[]{t});
                    SoundManager.this.queueClipFailure(buffer);
                    continue;
                }
                break;
            }
        }
    };
    protected boolean _sharingAL;
    protected RunQueue _rqueue;
    protected Listener _listener = new Listener();
    protected float _baseGain = 1.0f;
    protected HashMap<String, ClipBuffer> _loading = Maps.newHashMap();
    protected LRUHashMap<String, ClipBuffer> _clips = new LRUHashMap(0x4000000, _sizer);
    protected Queue<ClipBuffer> _toLoad;
    protected ArrayList<Stream> _streams = Lists.newArrayList();
    protected List<SoundGroup> _groups = Lists.newArrayList();
    protected int[] _finalizedSources;
    protected int[] _finalizedBuffers;
    protected static SoundManager _soundmgr;
    protected static LRUHashMap.ItemSizer<ClipBuffer> _sizer;
    protected static final int DEFAULT_CACHE_SIZE = 0x4000000;

    public static SoundManager createSoundManager(RunQueue rqueue) {
        if (_soundmgr != null) {
            throw new IllegalStateException("A sound manager has already been created.");
        }
        _soundmgr = new SoundManager(rqueue);
        return _soundmgr;
    }

    public void shutdown() {
        if (this.isInitialized() && !this._sharingAL) {
            AL.destroy();
        }
    }

    public boolean isInitialized() {
        return this._toLoad != null;
    }

    public void setCacheSize(int bytes) {
        this._clips.setMaxSize(bytes);
    }

    public Listener getListener() {
        return this._listener;
    }

    public void setBaseGain(float gain) {
        if (this._baseGain == gain) {
            return;
        }
        this._baseGain = gain;
        int nn = this._groups.size();
        for (int ii = 0; ii < nn; ++ii) {
            SoundGroup group = this._groups.get(ii);
            if (!(group.getBaseGain() < 0.0f)) continue;
            group.baseGainChanged();
        }
    }

    public float getBaseGain() {
        return this._baseGain;
    }

    public SoundGroup createGroup(ClipProvider provider, int sources) {
        return new SoundGroup(this, provider, sources);
    }

    public ArrayList<Stream> getStreams() {
        return this._streams;
    }

    public void updateStreams(final float time) {
        this._rqueue.postRunnable(new Runnable(){

            @Override
            public void run() {
                for (int ii = SoundManager.this._streams.size() - 1; ii >= 0; --ii) {
                    Stream stream = SoundManager.this._streams.get(ii);
                    try {
                        stream.update(time);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Log.log.error((Object)e.getMessage(), new Object[0]);
                        stream.dispose();
                    }
                }
                SoundManager.this.deleteFinalizedObjects();
            }
        });
    }

    public void loadClip(ClipProvider provider, String path) {
        this.loadClip(provider, path, null);
    }

    public void loadClip(ClipProvider provider, String path, ClipBuffer.Observer observer) {
        this.getClip(provider, path, observer);
    }

    protected SoundManager(RunQueue rqueue) {
        this._rqueue = rqueue;
        if (AL.isCreated()) {
            this._sharingAL = true;
        } else {
            try {
                AL.create((String)"", (int)44100, (int)15, (boolean)false);
            }
            catch (Exception e) {
                Log.log.warning((Object)"Failed to initialize sound system.", new Object[]{e});
                return;
            }
            int errno = AL10.alGetError();
            if (errno != 0) {
                Log.log.warning((Object)("Failed to initialize sound system [errno=" + errno + "]."), new Object[0]);
                return;
            }
        }
        this._clips.setRemovalObserver((LRUHashMap.RemovalObserver)new LRUHashMap.RemovalObserver<String, ClipBuffer>(){

            public void removedFromMap(LRUHashMap<String, ClipBuffer> map, final ClipBuffer item) {
                SoundManager.this._rqueue.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        Log.log.debug((Object)("Flushing " + item.getKey()), new Object[0]);
                        item.dispose();
                    }
                });
            }
        });
        this._toLoad = new Queue();
        this._loader.setDaemon(true);
        this._loader.start();
    }

    protected ClipBuffer getClip(ClipProvider provider, String path) {
        return this.getClip(provider, path, null);
    }

    protected ClipBuffer getClip(ClipProvider provider, String path, ClipBuffer.Observer observer) {
        String ckey = ClipBuffer.makeKey(provider, path);
        ClipBuffer buffer = (ClipBuffer)this._clips.get((Object)ckey);
        try {
            if (buffer == null && (buffer = this._loading.get(ckey)) == null) {
                buffer = new ClipBuffer(this, provider, path);
                this._loading.put(ckey, buffer);
            }
            buffer.resolve(observer);
            return buffer;
        }
        catch (Throwable t) {
            Log.log.warning((Object)("Failure resolving buffer [key=" + ckey + "]."), new Object[]{t});
            return null;
        }
    }

    protected void queueClipLoad(ClipBuffer buffer) {
        if (this._toLoad != null) {
            this._toLoad.append((Object)buffer);
        }
    }

    protected void queueClipFailure(final ClipBuffer buffer) {
        this._rqueue.postRunnable(new Runnable(){

            @Override
            public void run() {
                SoundManager.this._loading.remove(buffer.getKey());
                buffer.failed();
            }
        });
    }

    protected void restoreClip(ClipBuffer buffer) {
        this._clips.put((Object)buffer.getKey(), (Object)buffer);
    }

    protected void addStream(Stream stream) {
        this._streams.add(stream);
    }

    protected void removeStream(Stream stream) {
        this._streams.remove(stream);
    }

    protected void addGroup(SoundGroup group) {
        this._groups.add(group);
    }

    protected void removeGroup(SoundGroup group) {
        this._groups.remove(group);
    }

    protected synchronized void sourceFinalized(int id) {
        this._finalizedSources = IntListUtil.add((int[])this._finalizedSources, (int)id);
    }

    protected synchronized void bufferFinalized(int id) {
        this._finalizedBuffers = IntListUtil.add((int[])this._finalizedBuffers, (int)id);
    }

    protected synchronized void deleteFinalizedObjects() {
        IntBuffer idbuf;
        if (this._finalizedSources != null) {
            idbuf = BufferUtils.createIntBuffer((int)this._finalizedSources.length);
            idbuf.put(this._finalizedSources).rewind();
            AL10.alDeleteSources((IntBuffer)idbuf);
            this._finalizedSources = null;
        }
        if (this._finalizedBuffers != null) {
            idbuf = BufferUtils.createIntBuffer((int)this._finalizedBuffers.length);
            idbuf.put(this._finalizedBuffers).rewind();
            AL10.alDeleteBuffers((IntBuffer)idbuf);
            this._finalizedBuffers = null;
        }
    }

    static {
        _sizer = new LRUHashMap.ItemSizer<ClipBuffer>(){

            public int computeSize(ClipBuffer item) {
                return item.getSize();
            }
        };
    }
}

