/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.util;

import com.samskivert.util.RandomUtil;
import com.threerings.media.util.BobblePath;
import com.threerings.media.util.Pathable;

public class SmoothBobblePath
extends BobblePath {
    protected int _oldx;
    protected int _oldy;
    protected int _newx;
    protected int _newy;

    public SmoothBobblePath(int dx, int dy, long duration) {
        this(dx, dy, duration, 1L);
    }

    public SmoothBobblePath(int dx, int dy, long duration, long updateFreq) {
        super(dx, dy, duration, updateFreq);
    }

    @Override
    public void init(Pathable pable, long tickstamp) {
        super.init(pable, tickstamp);
        this._newx = this._sx;
        this._newy = this._sy;
        this._oldx = this._sx;
        this._oldy = this._sy;
    }

    @Override
    public boolean tick(Pathable pable, long tickStamp) {
        if (this._stopTime <= tickStamp) {
            boolean updated = this.updatePositionTo(pable, this._sy, this._sy);
            pable.pathCompleted(tickStamp);
            return updated;
        }
        if (this._nextMove < tickStamp) {
            this._oldx = this._newx;
            this._oldy = this._newy;
            do {
                this._newx = this._sx + RandomUtil.getInt((int)(this._dx * 2 + 1)) - this._dx;
                this._newy = this._sy + RandomUtil.getInt((int)(this._dy * 2 + 1)) - this._dy;
            } while (this._newx == this._oldx && this._newy == this._oldy);
            this._nextMove = tickStamp + this._updateFreq;
        }
        float movePerc = (float)(this._nextMove - tickStamp) / (float)this._updateFreq;
        int x = this._oldx + (int)((float)(this._newx - this._oldx) * movePerc);
        int y = this._oldy + (int)((float)(this._newy - this._oldy) * movePerc);
        return this.updatePositionTo(pable, x, y);
    }
}

