/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.image;

import com.samskivert.swing.RuntimeAdjust;
import com.threerings.media.MediaPrefs;
import com.threerings.media.image.BlankMirage;
import com.threerings.media.image.BufferedMirage;
import com.threerings.media.image.CachedVolatileMirage;
import com.threerings.media.image.Colorization;
import com.threerings.media.image.ImageManager;
import com.threerings.media.image.Mirage;
import com.threerings.resource.ResourceManager;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class ClientImageManager
extends ImageManager {
    protected static RuntimeAdjust.IntAdjust _cacheSize = new RuntimeAdjust.IntAdjust("Size (in kb of memory used) of the image manager LRU cache [requires restart]", "narya.media.image.cache_size", MediaPrefs.config, DEFAULT_CACHE_SIZE);
    protected static int _runCacheSize = _cacheSize.getValue();
    protected static RuntimeAdjust.BooleanAdjust _prepareImages = new RuntimeAdjust.BooleanAdjust("Cause image manager to optimize all images for display.", "narya.media.image.prep_images", MediaPrefs.config, true);
    protected static boolean _runPrepareImages = _prepareImages.getValue();
    protected static RuntimeAdjust.BooleanAdjust _runBlank = new RuntimeAdjust.BooleanAdjust("Cause image manager to return blank images.", "narya.media.image.run_blank", MediaPrefs.config, false);

    public static void setCacheSize(int cacheKilobytes) {
        _runCacheSize = cacheKilobytes;
    }

    public static void setPrepareImages(boolean prepareImages) {
        _runPrepareImages = prepareImages;
    }

    public ClientImageManager(ResourceManager rmgr, ImageManager.OptimalImageCreator icreator) {
        super(rmgr, icreator);
    }

    public ClientImageManager(ResourceManager rmgr, Component context) {
        super(rmgr, context);
    }

    @Override
    public int getCacheSize() {
        return _runCacheSize;
    }

    @Override
    public Mirage getMirage(ImageManager.ImageKey key, Rectangle bounds, Colorization[] zations) {
        BufferedImage src = null;
        float percentageOfDataBuffer = 1.0f;
        if (bounds == null) {
            src = this.getImage(key, zations);
            bounds = new Rectangle(0, 0, src.getWidth(), src.getHeight());
        } else if (!_runPrepareImages) {
            src = this.getImage(key, zations);
            percentageOfDataBuffer = (float)(bounds.width * bounds.height) / (float)(src.getHeight() * src.getWidth());
            src = src.getSubimage(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        if (_runBlank.getValue()) {
            return new BlankMirage(bounds.width, bounds.height);
        }
        if (_runPrepareImages) {
            return new CachedVolatileMirage(this, key, bounds, zations);
        }
        return new BufferedMirage(src, percentageOfDataBuffer);
    }
}

