/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.image;

import com.threerings.media.Log;
import com.threerings.media.image.ImageManager;
import com.threerings.media.image.VolatileMirage;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class BackedVolatileMirage
extends VolatileMirage {
    protected BufferedImage _source;

    public BackedVolatileMirage(ImageManager imgr, BufferedImage source) {
        super(imgr, new Rectangle(0, 0, source.getWidth(), source.getHeight()));
        this._source = source;
        this.createVolatileImage();
    }

    @Override
    protected int getTransparency() {
        return this._source.getColorModel().getTransparency();
    }

    @Override
    protected void refreshVolatileImage() {
        Graphics gfx = this._image.getGraphics();
        try {
            gfx.drawImage(this._source, -this._bounds.x, -this._bounds.y, null);
        }
        catch (Exception e) {
            Log.log.warning((Object)("Failure refreshing mirage " + this + "."), new Object[]{e});
        }
        finally {
            gfx.dispose();
        }
    }

    @Override
    protected void toString(StringBuilder buf) {
        super.toString(buf);
        buf.append(", src=").append(this._source);
    }
}

